/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Worm;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class WormMutation {
    private final List<UTranslate> translations = new ArrayList<UTranslate>();

    private WormMutation() {
    }

    public static WormMutation create(Worm worm, double d) {
        String string = worm.getDirectionsCode();
        if (string.length() > 2) {
            return WormMutation.createFromLongSignature(string, d);
        }
        return WormMutation.createFromSimpleSignature(string, d);
    }

    private static WormMutation createFromLongSignature(String string, double d) {
        WormMutation wormMutation = new WormMutation();
        for (int i = 0; i < string.length() - 1; ++i) {
            WormMutation wormMutation2 = WormMutation.createFromSimpleSignature(string.substring(i, i + 2), d);
            if (i == 0) {
                wormMutation.translations.add(wormMutation2.translations.get(0));
            } else {
                UTranslate uTranslate = wormMutation.getLast();
                if (!uTranslate.isAlmostSame(wormMutation2.translations.get(0))) {
                    wormMutation2 = wormMutation2.reverse();
                }
            }
            wormMutation.translations.add(wormMutation2.translations.get(1));
            if (i != string.length() - 2) continue;
            wormMutation.translations.add(wormMutation2.translations.get(2));
        }
        return wormMutation;
    }

    private WormMutation reverse() {
        WormMutation wormMutation = new WormMutation();
        for (UTranslate uTranslate : this.translations) {
            wormMutation.translations.add(uTranslate.reverse());
        }
        return wormMutation;
    }

    public UTranslate getLast() {
        return this.translations.get(this.translations.size() - 1);
    }

    public UTranslate getFirst() {
        return this.translations.get(0);
    }

    public int size() {
        return this.translations.size();
    }

    private static WormMutation createFromSimpleSignature(String string, double d) {
        WormMutation wormMutation = new WormMutation();
        if (string.equals("D") || string.equals("U")) {
            UTranslate uTranslate = new UTranslate(d, 0.0);
            wormMutation.translations.add(uTranslate);
            wormMutation.translations.add(uTranslate);
            return wormMutation;
        }
        if (string.equals("L") || string.equals("R")) {
            UTranslate uTranslate = new UTranslate(0.0, d);
            wormMutation.translations.add(uTranslate);
            wormMutation.translations.add(uTranslate);
            return wormMutation;
        }
        if (string.equals("RD")) {
            wormMutation.translations.add(new UTranslate(0.0, -d));
            wormMutation.translations.add(new UTranslate(d, -d));
            wormMutation.translations.add(new UTranslate(d, 0.0));
            return wormMutation;
        }
        if (string.equals("RU")) {
            wormMutation.translations.add(new UTranslate(0.0, d));
            wormMutation.translations.add(new UTranslate(d, d));
            wormMutation.translations.add(new UTranslate(d, 0.0));
            return wormMutation;
        }
        if (string.equals("LD")) {
            wormMutation.translations.add(new UTranslate(0.0, -d));
            wormMutation.translations.add(new UTranslate(-d, -d));
            wormMutation.translations.add(new UTranslate(-d, 0.0));
            return wormMutation;
        }
        if (string.equals("DL")) {
            wormMutation.translations.add(new UTranslate(d, 0.0));
            wormMutation.translations.add(new UTranslate(d, d));
            wormMutation.translations.add(new UTranslate(0.0, d));
            return wormMutation;
        }
        if (string.equals("DR")) {
            wormMutation.translations.add(new UTranslate(-d, 0.0));
            wormMutation.translations.add(new UTranslate(-d, d));
            wormMutation.translations.add(new UTranslate(0.0, d));
            return wormMutation;
        }
        if (string.equals("UL")) {
            wormMutation.translations.add(new UTranslate(d, 0.0));
            wormMutation.translations.add(new UTranslate(d, -d));
            wormMutation.translations.add(new UTranslate(0.0, -d));
            return wormMutation;
        }
        if (string.equals("UR")) {
            wormMutation.translations.add(new UTranslate(-d, 0.0));
            wormMutation.translations.add(new UTranslate(-d, -d));
            wormMutation.translations.add(new UTranslate(0.0, -d));
            return wormMutation;
        }
        throw new UnsupportedOperationException(string);
    }

    public UTranslate getTextTranslate(int n) {
        MinMax minMax = new MinMax();
        for (UTranslate uTranslate : this.translations) {
            minMax.append(uTranslate.getDx());
        }
        return new UTranslate(minMax.getExtreme() * (double)(n - 1), 0.0);
    }

    public boolean isDxNegative() {
        return this.translations.get(0).getDx() < 0.0;
    }

    public Worm mute(Worm worm) {
        Worm worm2 = new Worm();
        for (int i = 0; i < worm.size(); ++i) {
            worm2.addPoint(this.translations.get(i).getTranslated(worm.get(i)));
        }
        return worm2;
    }

    private static class MinMax {
        private double min = Double.MAX_VALUE;
        private double max = Double.MIN_VALUE;

        private MinMax() {
        }

        private void append(double d) {
            if (d > this.max) {
                this.max = d;
            }
            if (d < this.min) {
                this.min = d;
            }
        }

        private double getExtreme() {
            if (Math.abs(this.max) > Math.abs(this.min)) {
                return this.max;
            }
            return this.min;
        }
    }
}

