/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.awt.geom.Dimension2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.LineBreakStrategy;
import znaishaded.net.sourceforge.plantuml.SkinParamUtils;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.creole.CreoleParser;
import znaishaded.net.sourceforge.plantuml.creole.Sheet;
import znaishaded.net.sourceforge.plantuml.creole.SheetBlock1;
import znaishaded.net.sourceforge.plantuml.creole.SheetBlock2;
import znaishaded.net.sourceforge.plantuml.creole.Stencil;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorAndStyle;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.UDrawable;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileBox
extends AbstractFtile {
    private static final int MARGIN = 10;
    private final TextBlock tb;
    private final LinkRendering inRenreding;
    private final Swimlane swimlane;
    private final BoxStyle style;
    private final ISkinParam skinParam;
    private final String print;

    @Override
    public final LinkRendering getInLinkRendering() {
        return this.inRenreding;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    public FtileBox(ISkinParam iSkinParam, Display display, UFont uFont, Swimlane swimlane, BoxStyle boxStyle) {
        super(iSkinParam);
        this.style = boxStyle;
        this.skinParam = iSkinParam;
        this.swimlane = swimlane;
        this.inRenreding = new LinkRendering(HtmlColorAndStyle.build(iSkinParam));
        FontConfiguration fontConfiguration = new FontConfiguration(iSkinParam, FontParam.ACTIVITY, null);
        Sheet sheet = new CreoleParser(fontConfiguration, iSkinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), iSkinParam, CreoleMode.FULL).createSheet(display);
        this.tb = new SheetBlock2(new SheetBlock1(sheet, LineBreakStrategy.NONE, iSkinParam.getPadding()), new MyStencil(), new UStroke(1.0));
        this.print = display.toString();
    }

    public String toString() {
        return this.print;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        FtileGeometry ftileGeometry = this.calculateDimension(uGraphic.getStringBounder());
        double d = ((Dimension2D)ftileGeometry).getWidth();
        double d2 = ((Dimension2D)ftileGeometry).getHeight();
        UDrawable uDrawable = this.style.getUDrawable(d, d2, this.skinParam().shadowing());
        HtmlColor htmlColor = SkinParamUtils.getColor(this.skinParam, ColorParam.activityBorder, null);
        HtmlColor htmlColor2 = SkinParamUtils.getColor(this.skinParam, ColorParam.activityBackground, null);
        uGraphic = uGraphic.apply(new UChangeColor(htmlColor)).apply(new UChangeBackColor(htmlColor2)).apply(this.getThickness());
        uDrawable.drawU(uGraphic);
        this.tb.drawU(uGraphic.apply(new UTranslate(10.0, 10.0)));
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.tb.calculateDimension(stringBounder);
        return new FtileGeometry(Dimension2DDouble.delta(dimension2D, 20.0, 20.0), dimension2D.getWidth() / 2.0 + 10.0, 0.0, dimension2D.getHeight() + 20.0);
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.emptyList();
    }

    class MyStencil
    implements Stencil {
        MyStencil() {
        }

        public double getStartingX(StringBounder stringBounder, double d) {
            return -10.0;
        }

        public double getEndingX(StringBounder stringBounder, double d) {
            FtileGeometry ftileGeometry = FtileBox.this.calculateDimension(stringBounder);
            return ((Dimension2D)ftileGeometry).getWidth() - 10.0;
        }
    }
}

