/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.braille;

import znaishaded.net.sourceforge.plantuml.braille.BrailleGrid;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorSetSimple;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorUtils;
import znaishaded.net.sourceforge.plantuml.graphic.UDrawable;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class BrailleDrawer
implements UDrawable {
    private final BrailleGrid grid;
    private final double step = 9.0;
    private final double spotSize = 5.0;

    public BrailleDrawer(BrailleGrid brailleGrid) {
        this.grid = brailleGrid;
    }

    public void drawU(UGraphic uGraphic) {
        int n;
        uGraphic = uGraphic.apply(new UChangeColor(new HtmlColorSetSimple().getColorIfValid("#F0F0F0")));
        for (n = this.grid.getMinX(); n <= this.grid.getMaxX(); ++n) {
            uGraphic.apply(new UTranslate((double)n * 9.0 + 5.0 + 1.0, 0.0)).draw(new ULine(0.0, (double)(this.grid.getMaxY() - this.grid.getMinY()) * 9.0));
        }
        for (n = this.grid.getMinY(); n <= this.grid.getMaxY(); ++n) {
            uGraphic.apply(new UTranslate(0.0, (double)n * 9.0 + 5.0 + 1.0)).draw(new ULine((double)(this.grid.getMaxX() - this.grid.getMinX()) * 9.0, 0.0));
        }
        uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK)).apply(new UChangeBackColor(HtmlColorUtils.BLACK));
        for (n = this.grid.getMinX(); n <= this.grid.getMaxX(); ++n) {
            for (int i = this.grid.getMinY(); i <= this.grid.getMaxY(); ++i) {
                if (!this.grid.getState(n, i)) continue;
                this.drawCircle(uGraphic, n, i);
            }
        }
    }

    private void drawCircle(UGraphic uGraphic, int n, int n2) {
        double d = (double)n * 9.0;
        double d2 = (double)n2 * 9.0;
        uGraphic.apply(new UTranslate(d, d2)).draw(new UEllipse(5.0, 5.0));
    }
}

