/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.braille;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.braille.Coords;
import znaishaded.net.sourceforge.plantuml.posimo.DotPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrailleGrid {
    private int minX;
    private int minY;
    private int maxX;
    private int maxY;
    private final double quanta;
    private final Set<Coords> on = new HashSet<Coords>();

    public BrailleGrid(double d) {
        this.quanta = d;
    }

    public boolean getState(int n, int n2) {
        Coords coords = new Coords(n, n2);
        return this.on.contains(coords);
    }

    private void setStateDouble(double d, double d2, boolean bl) {
        this.setState(this.toInt(d), this.toInt(d2), bl);
    }

    public void setState(int n, int n2, boolean bl) {
        Coords coords = new Coords(n, n2);
        if (bl) {
            this.on.add(coords);
        } else {
            this.on.remove(coords);
        }
        this.minX = Math.min(this.minX, n);
        this.maxX = Math.max(this.maxX, n);
        this.minY = Math.min(this.minY, n2);
        this.maxY = Math.max(this.maxY, n2);
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public void rectangle(double d, double d2, double d3, double d4) {
        this.hline(d2, d, d + d3);
        this.hline(d2 + d4, d, d + d3);
        this.vline(d, d2, d2 + d4);
        this.vline(d + d3, d2, d2 + d4);
    }

    private void vline(double d, double d2, double d3) {
        int n = this.toInt(d);
        int n2 = this.toInt(d2);
        int n3 = this.toInt(d3);
        for (int i = n2; i <= n3; ++i) {
            this.setState(n, i, true);
        }
    }

    private void hline(double d, double d2, double d3) {
        int n = this.toInt(d);
        int n2 = this.toInt(d2);
        int n3 = this.toInt(d3);
        for (int i = n2; i <= n3; ++i) {
            this.setState(i, n, true);
        }
    }

    public int toInt(double d) {
        return (int)Math.round(d / this.quanta);
    }

    public void line(double d, double d2, double d3, double d4) {
        if (d == d3) {
            this.vline(d, d2, d4);
        } else if (d2 == d4) {
            this.hline(d2, d, d3);
        } else {
            System.err.println("warning line");
        }
    }

    public double getQuanta() {
        return this.quanta;
    }

    public void drawDotPath(double d, double d2, DotPath dotPath) {
        for (CubicCurve2D.Double double_ : dotPath.getBeziers()) {
            this.drawCubic(d, d2, double_);
        }
    }

    private void drawCubic(double d, double d2, CubicCurve2D.Double double_) {
        this.drawPointInternal(d, d2, double_.getP1());
        this.drawPointInternal(d, d2, double_.getP2());
        if (double_.getP1().distance(double_.getP2()) > this.quanta) {
            CubicCurve2D.Double double_2 = new CubicCurve2D.Double();
            CubicCurve2D.Double double_3 = new CubicCurve2D.Double();
            double_.subdivide(double_2, double_3);
            this.drawCubic(d, d2, double_2);
            this.drawCubic(d, d2, double_3);
        }
    }

    private void drawPointInternal(double d, double d2, Point2D point2D) {
        this.setStateDouble(d + point2D.getX(), d2 + point2D.getY(), true);
    }

    public void drawPolygon(List<Point2D> list) {
        for (int i = 0; i < list.size() - 1; ++i) {
            this.drawLineInternal(list.get(i), list.get(i + 1));
        }
        this.drawLineInternal(list.get(list.size() - 1), list.get(0));
    }

    private void drawLineInternal(Point2D point2D, Point2D point2D2) {
        this.drawPointInternal(0.0, 0.0, point2D);
        this.drawPointInternal(0.0, 0.0, point2D2);
        if (point2D.distance(point2D2) > this.quanta) {
            Point2D.Double double_ = new Point2D.Double((point2D.getX() + point2D2.getX()) / 2.0, (point2D.getY() + point2D2.getY()) / 2.0);
            this.drawLineInternal(point2D, double_);
            this.drawLineInternal(double_, point2D2);
        }
    }
}

