/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.code;

import znaishaded.net.sourceforge.plantuml.code.URLEncoder;

public class AsciiEncoder
implements URLEncoder {
    private final char[] encode6bit = new char[64];
    private final byte[] decode6bit = new byte[128];

    public AsciiEncoder() {
        for (byte by = 0; by < 64; by = (byte)(by + 1)) {
            this.encode6bit[by] = this.encode6bit(by);
            this.decode6bit[this.encode6bit[by]] = by;
        }
    }

    public String encode(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder((byArray.length * 4 + 2) / 3);
        for (int i = 0; i < byArray.length; i += 3) {
            this.append3bytes(stringBuilder, byArray[i] & 0xFF, i + 1 < byArray.length ? byArray[i + 1] & 0xFF : 0, i + 2 < byArray.length ? byArray[i + 2] & 0xFF : 0);
        }
        return stringBuilder.toString();
    }

    public byte[] decode(String string) {
        if (string.length() % 4 != 0) {
            throw new IllegalArgumentException("Cannot decode " + string);
        }
        byte[] byArray = new byte[(string.length() * 3 + 3) / 4];
        int n = 0;
        for (int i = 0; i < string.length(); i += 4) {
            this.decode3bytes(byArray, n, string.charAt(i), string.charAt(i + 1), string.charAt(i + 2), string.charAt(i + 3));
            n += 3;
        }
        return byArray;
    }

    public int decode6bit(char c) {
        return this.decode6bit[c];
    }

    public char encode6bit(byte by) {
        assert (by >= 0 && by < 64);
        if (by < 10) {
            return (char)(48 + by);
        }
        if ((by = (byte)(by - 10)) < 26) {
            return (char)(65 + by);
        }
        if ((by = (byte)(by - 26)) < 26) {
            return (char)(97 + by);
        }
        if ((by = (byte)(by - 26)) == 0) {
            return '-';
        }
        if (by == 1) {
            return '_';
        }
        assert (false);
        return '?';
    }

    private void append3bytes(StringBuilder stringBuilder, int n, int n2, int n3) {
        int n4 = n >> 2;
        int n5 = (n & 3) << 4 | n2 >> 4;
        int n6 = (n2 & 0xF) << 2 | n3 >> 6;
        int n7 = n3 & 0x3F;
        stringBuilder.append(this.encode6bit[n4 & 0x3F]);
        stringBuilder.append(this.encode6bit[n5 & 0x3F]);
        stringBuilder.append(this.encode6bit[n6 & 0x3F]);
        stringBuilder.append(this.encode6bit[n7 & 0x3F]);
    }

    private void decode3bytes(byte[] byArray, int n, char c, char c2, char c3, char c4) {
        byte by = this.decode6bit[c];
        byte by2 = this.decode6bit[c2];
        byte by3 = this.decode6bit[c3];
        byte by4 = this.decode6bit[c4];
        byArray[n] = (byte)(by << 2 | by2 >> 4);
        byArray[n + 1] = (byte)((by2 & 0xF) << 4 | by3 >> 2);
        byArray[n + 2] = (byte)((by3 & 3) << 6 | by4);
    }
}

