/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole;

import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.creole.Command;
import znaishaded.net.sourceforge.plantuml.creole.StripeSimple;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorSet;

public class CommandCreoleColorChange
implements Command {
    private final Pattern2 pattern;

    public static Command create() {
        return new CommandCreoleColorChange("^(?i)(\\<color[\\s:]+(#[0-9a-fA-F]{6}|#?\\w+)[%s]*\\>(.*?)\\</color\\>)");
    }

    public static Command createEol() {
        return new CommandCreoleColorChange("^(?i)(\\<color[\\s:]+(#[0-9a-fA-F]{6}|#?\\w+)[%s]*\\>(.*)$)");
    }

    private CommandCreoleColorChange(String string) {
        this.pattern = MyPattern.cmpile(string);
    }

    public int matchingSize(String string) {
        Matcher2 matcher2 = this.pattern.matcher(string);
        if (!matcher2.find()) {
            return 0;
        }
        return matcher2.group(2).length();
    }

    public String executeAndGetRemaining(String string, StripeSimple stripeSimple) {
        Matcher2 matcher2 = this.pattern.matcher(string);
        if (!matcher2.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fontConfiguration = stripeSimple.getActualFontConfiguration();
        HtmlColor htmlColor = HtmlColorSet.getInstance().getColorIfValid(matcher2.group(2));
        FontConfiguration fontConfiguration2 = fontConfiguration.changeColor(htmlColor);
        stripeSimple.setActualFontConfiguration(fontConfiguration2);
        stripeSimple.analyzeAndAdd(matcher2.group(3));
        stripeSimple.setActualFontConfiguration(fontConfiguration);
        return string.substring(matcher2.group(1).length());
    }
}

