/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole;

import znaishaded.net.sourceforge.plantuml.BackSlash;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.creole.CreoleContext;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.creole.Stripe;
import znaishaded.net.sourceforge.plantuml.creole.StripeSimple;
import znaishaded.net.sourceforge.plantuml.creole.StripeStyle;
import znaishaded.net.sourceforge.plantuml.creole.StripeStyleType;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.utils.CharHidder;

public class CreoleStripeSimpleParser {
    private final String line;
    private final StripeStyle style;
    private final CreoleMode modeSimpleLine;
    private final FontConfiguration fontConfiguration;
    private final ISkinSimple skinParam;

    public CreoleStripeSimpleParser(String string, CreoleContext creoleContext, FontConfiguration fontConfiguration, ISkinSimple iSkinSimple, CreoleMode creoleMode) {
        Pattern2 pattern2;
        Matcher2 matcher2;
        if (string.contains("" + BackSlash.hiddenNewLine())) {
            throw new IllegalArgumentException(string);
        }
        this.fontConfiguration = fontConfiguration;
        this.modeSimpleLine = creoleMode;
        this.skinParam = iSkinSimple;
        if (iSkinSimple == null) {
            throw new IllegalArgumentException();
        }
        Pattern2 pattern22 = MyPattern.cmpile("^--([^-]*)--$");
        Matcher2 matcher22 = pattern22.matcher(string);
        if (matcher22.find()) {
            this.line = matcher22.group(1);
            this.style = new StripeStyle(StripeStyleType.HORIZONTAL_LINE, 0, '-');
            return;
        }
        Pattern2 pattern23 = MyPattern.cmpile("^==([^=]*)==$");
        Matcher2 matcher23 = pattern23.matcher(string);
        if (matcher23.find()) {
            this.line = matcher23.group(1);
            this.style = new StripeStyle(StripeStyleType.HORIZONTAL_LINE, 0, '=');
            return;
        }
        Pattern2 pattern24 = MyPattern.cmpile("^===*==$");
        Matcher2 matcher24 = pattern24.matcher(string);
        if (matcher24.find()) {
            this.line = "";
            this.style = new StripeStyle(StripeStyleType.HORIZONTAL_LINE, 0, '=');
            return;
        }
        Pattern2 pattern25 = MyPattern.cmpile("^\\.\\.([^\\.]*)\\.\\.$");
        Matcher2 matcher25 = pattern25.matcher(string);
        if (matcher25.find()) {
            this.line = matcher25.group(1);
            this.style = new StripeStyle(StripeStyleType.HORIZONTAL_LINE, 0, '.');
            return;
        }
        if (creoleMode == CreoleMode.FULL && (matcher2 = (pattern2 = MyPattern.cmpile("^(\\*+)([^*]+(?:[^*]|\\*\\*[^*]+\\*\\*)*)$")).matcher(string)).find()) {
            this.line = StringUtils.trin(matcher2.group(2));
            int n = matcher2.group(1).length() - 1;
            this.style = new StripeStyle(StripeStyleType.LIST_WITHOUT_NUMBER, n, '\u0000');
            return;
        }
        if (creoleMode == CreoleMode.FULL && (matcher2 = (pattern2 = MyPattern.cmpile("^(#+)(.+)$")).matcher(CharHidder.hide(string))).find()) {
            this.line = StringUtils.trin(CharHidder.unhide(matcher2.group(2)));
            int n = CharHidder.unhide(matcher2.group(1)).length() - 1;
            this.style = new StripeStyle(StripeStyleType.LIST_WITH_NUMBER, n, '\u0000');
            return;
        }
        pattern2 = MyPattern.cmpile("^(=+)(.+)$");
        matcher2 = pattern2.matcher(string);
        if (matcher2.find()) {
            this.line = StringUtils.trin(matcher2.group(2));
            int n = matcher2.group(1).length() - 1;
            this.style = new StripeStyle(StripeStyleType.HEADING, n, '\u0000');
            return;
        }
        this.line = string;
        this.style = new StripeStyle(StripeStyleType.NORMAL, 0, '\u0000');
    }

    public Stripe createStripe(CreoleContext creoleContext) {
        StripeSimple stripeSimple = new StripeSimple(this.fontConfiguration, this.style, creoleContext, this.skinParam, this.modeSimpleLine);
        stripeSimple.analyzeAndAdd(this.line);
        return stripeSimple;
    }
}

