/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.BackSlash;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.creole.Atom;
import znaishaded.net.sourceforge.plantuml.creole.AtomImg;
import znaishaded.net.sourceforge.plantuml.creole.AtomMath;
import znaishaded.net.sourceforge.plantuml.creole.AtomOpenIcon;
import znaishaded.net.sourceforge.plantuml.creole.AtomSpace;
import znaishaded.net.sourceforge.plantuml.creole.AtomSprite;
import znaishaded.net.sourceforge.plantuml.creole.AtomText;
import znaishaded.net.sourceforge.plantuml.creole.Command;
import znaishaded.net.sourceforge.plantuml.creole.CommandCreoleColorAndSizeChange;
import znaishaded.net.sourceforge.plantuml.creole.CommandCreoleColorChange;
import znaishaded.net.sourceforge.plantuml.creole.CommandCreoleExposantChange;
import znaishaded.net.sourceforge.plantuml.creole.CommandCreoleFontFamilyChange;
import znaishaded.net.sourceforge.plantuml.creole.CommandCreoleImg;
import znaishaded.net.sourceforge.plantuml.creole.CommandCreoleLatex;
import znaishaded.net.sourceforge.plantuml.creole.CommandCreoleMath;
import znaishaded.net.sourceforge.plantuml.creole.CommandCreoleMonospaced;
import znaishaded.net.sourceforge.plantuml.creole.CommandCreoleOpenIcon;
import znaishaded.net.sourceforge.plantuml.creole.CommandCreoleSizeChange;
import znaishaded.net.sourceforge.plantuml.creole.CommandCreoleSpace;
import znaishaded.net.sourceforge.plantuml.creole.CommandCreoleSprite;
import znaishaded.net.sourceforge.plantuml.creole.CommandCreoleStyle;
import znaishaded.net.sourceforge.plantuml.creole.CommandCreoleSvgAttributeChange;
import znaishaded.net.sourceforge.plantuml.creole.CommandCreoleUrl;
import znaishaded.net.sourceforge.plantuml.creole.CreoleContext;
import znaishaded.net.sourceforge.plantuml.creole.CreoleHorizontalLine;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.creole.Stripe;
import znaishaded.net.sourceforge.plantuml.creole.StripeStyle;
import znaishaded.net.sourceforge.plantuml.creole.StripeStyleType;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.FontPosition;
import znaishaded.net.sourceforge.plantuml.graphic.FontStyle;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.ImgValign;
import znaishaded.net.sourceforge.plantuml.math.ScientificEquationSafe;
import znaishaded.net.sourceforge.plantuml.openiconic.OpenIcon;
import znaishaded.net.sourceforge.plantuml.ugraphic.sprite.Sprite;
import znaishaded.net.sourceforge.plantuml.utils.CharHidder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StripeSimple
implements Stripe {
    private final List<Atom> atoms = new ArrayList<Atom>();
    private final List<Command> commands = new ArrayList<Command>();
    private HorizontalAlignment align = HorizontalAlignment.LEFT;
    private FontConfiguration fontConfiguration;
    private final StripeStyle style;
    private final ISkinSimple skinParam;

    public void setCellAlignment(HorizontalAlignment horizontalAlignment) {
        this.align = horizontalAlignment;
    }

    public HorizontalAlignment getCellAlignment() {
        return this.align;
    }

    public String toString() {
        return super.toString() + " " + this.atoms.toString();
    }

    public StripeSimple(FontConfiguration fontConfiguration, StripeStyle stripeStyle, CreoleContext creoleContext, ISkinSimple iSkinSimple, CreoleMode creoleMode) {
        this.fontConfiguration = fontConfiguration;
        this.style = stripeStyle;
        this.skinParam = iSkinSimple;
        this.commands.add(CommandCreoleStyle.createCreole(FontStyle.BOLD));
        this.commands.add(CommandCreoleStyle.createLegacy(FontStyle.BOLD));
        this.commands.add(CommandCreoleStyle.createLegacyEol(FontStyle.BOLD));
        this.commands.add(CommandCreoleStyle.createCreole(FontStyle.ITALIC));
        this.commands.add(CommandCreoleStyle.createLegacy(FontStyle.ITALIC));
        this.commands.add(CommandCreoleStyle.createLegacyEol(FontStyle.ITALIC));
        this.commands.add(CommandCreoleStyle.createLegacy(FontStyle.PLAIN));
        this.commands.add(CommandCreoleStyle.createLegacyEol(FontStyle.PLAIN));
        if (creoleMode == CreoleMode.FULL) {
            this.commands.add(CommandCreoleStyle.createCreole(FontStyle.UNDERLINE));
        }
        this.commands.add(CommandCreoleStyle.createLegacy(FontStyle.UNDERLINE));
        this.commands.add(CommandCreoleStyle.createLegacyEol(FontStyle.UNDERLINE));
        this.commands.add(CommandCreoleStyle.createCreole(FontStyle.STRIKE));
        this.commands.add(CommandCreoleStyle.createLegacy(FontStyle.STRIKE));
        this.commands.add(CommandCreoleStyle.createLegacyEol(FontStyle.STRIKE));
        this.commands.add(CommandCreoleStyle.createCreole(FontStyle.WAVE));
        this.commands.add(CommandCreoleStyle.createLegacy(FontStyle.WAVE));
        this.commands.add(CommandCreoleStyle.createLegacyEol(FontStyle.WAVE));
        this.commands.add(CommandCreoleStyle.createLegacy(FontStyle.BACKCOLOR));
        this.commands.add(CommandCreoleStyle.createLegacyEol(FontStyle.BACKCOLOR));
        this.commands.add(CommandCreoleSizeChange.create());
        this.commands.add(CommandCreoleSizeChange.createEol());
        this.commands.add(CommandCreoleColorChange.create());
        this.commands.add(CommandCreoleColorChange.createEol());
        this.commands.add(CommandCreoleColorAndSizeChange.create());
        this.commands.add(CommandCreoleColorAndSizeChange.createEol());
        this.commands.add(CommandCreoleExposantChange.create(FontPosition.EXPOSANT));
        this.commands.add(CommandCreoleExposantChange.create(FontPosition.INDICE));
        this.commands.add(CommandCreoleImg.create());
        this.commands.add(CommandCreoleOpenIcon.create());
        double d = (double)iSkinSimple.getDpi() / 96.0;
        this.commands.add(CommandCreoleMath.create(d));
        this.commands.add(CommandCreoleLatex.create(d));
        this.commands.add(CommandCreoleSprite.create());
        this.commands.add(CommandCreoleSpace.create());
        this.commands.add(CommandCreoleFontFamilyChange.create());
        this.commands.add(CommandCreoleFontFamilyChange.createEol());
        this.commands.add(CommandCreoleMonospaced.create(iSkinSimple.getMonospacedFamily()));
        this.commands.add(CommandCreoleUrl.create(iSkinSimple));
        this.commands.add(CommandCreoleSvgAttributeChange.create());
        Atom atom = stripeStyle.getHeader(fontConfiguration, creoleContext);
        if (atom != null) {
            this.atoms.add(atom);
        }
    }

    @Override
    public List<Atom> getAtoms() {
        if (this.atoms.size() == 0) {
            this.atoms.add(AtomText.create(" ", this.fontConfiguration));
        }
        return Collections.unmodifiableList(this.atoms);
    }

    public FontConfiguration getActualFontConfiguration() {
        return this.fontConfiguration;
    }

    public void setActualFontConfiguration(FontConfiguration fontConfiguration) {
        this.fontConfiguration = fontConfiguration;
    }

    public void analyzeAndAdd(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.contains("" + BackSlash.hiddenNewLine())) {
            throw new IllegalArgumentException(string);
        }
        string = CharHidder.hide(string);
        if (this.style.getType() == StripeStyleType.HEADING) {
            this.atoms.add(AtomText.createHeading(string, this.fontConfiguration, this.style.getOrder()));
        } else if (this.style.getType() == StripeStyleType.HORIZONTAL_LINE) {
            this.atoms.add(CreoleHorizontalLine.create(this.fontConfiguration, string, this.style.getStyle(), this.skinParam));
        } else {
            this.modifyStripe(string);
        }
    }

    public void addImage(String string, double d) {
        this.atoms.add(AtomImg.create(string, ImgValign.TOP, 0, d));
    }

    public void addSpace(int n) {
        this.atoms.add(AtomSpace.create(n));
    }

    public void addUrl(Url url) {
        this.atoms.add(AtomText.createUrl(url, this.fontConfiguration));
    }

    public void addSprite(String string, double d) {
        Sprite sprite = this.skinParam.getSprite(string);
        if (sprite != null) {
            this.atoms.add(new AtomSprite(sprite.asTextBlock(this.fontConfiguration.getColor(), d), this.fontConfiguration));
        }
    }

    public void addOpenIcon(String string) {
        OpenIcon openIcon = OpenIcon.retrieve(string);
        if (openIcon != null) {
            this.atoms.add(new AtomOpenIcon(openIcon, this.fontConfiguration));
        }
    }

    public void addMath(ScientificEquationSafe scientificEquationSafe, double d) {
        this.atoms.add(new AtomMath(scientificEquationSafe, this.fontConfiguration.getColor(), this.fontConfiguration.getExtendedColor(), d));
    }

    private void modifyStripe(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        while (string.length() > 0) {
            Command command = this.searchCommand(string);
            if (command == null) {
                stringBuilder.append(string.charAt(0));
                string = string.substring(1);
                continue;
            }
            this.addPending(stringBuilder);
            string = command.executeAndGetRemaining(string, this);
        }
        this.addPending(stringBuilder);
    }

    private void addPending(StringBuilder stringBuilder) {
        if (stringBuilder.length() == 0) {
            return;
        }
        this.atoms.add(AtomText.create(stringBuilder.toString(), this.fontConfiguration));
        stringBuilder.setLength(0);
    }

    private Command searchCommand(String string) {
        for (Command command : this.commands) {
            int n = command.matchingSize(string);
            if (n == 0) continue;
            return command;
        }
        return null;
    }
}

