/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.geom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import znaishaded.net.sourceforge.plantuml.geom.LineSegmentInt;
import znaishaded.net.sourceforge.plantuml.geom.Neighborhood;
import znaishaded.net.sourceforge.plantuml.geom.Point2DInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Singularity {
    private final TreeSet<Double> angles = new TreeSet();
    private final Point2DInt center;

    public Singularity(Point2DInt point2DInt) {
        this.center = point2DInt;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.center.toString());
        for (Double d : this.angles) {
            int n = (int)(d * 180.0 / Math.PI);
            stringBuilder.append(' ');
            stringBuilder.append(n);
        }
        return stringBuilder.toString();
    }

    public void addLineSegment(LineSegmentInt lineSegmentInt) {
        if (lineSegmentInt.getP1().equals(this.center)) {
            this.angles.add(Singularity.convertAngle(lineSegmentInt.getAngle()));
        } else if (lineSegmentInt.getP2().equals(this.center)) {
            this.angles.add(Singularity.convertAngle(lineSegmentInt.getOppositeAngle()));
        } else {
            assert (lineSegmentInt.side(this.center) == 0.0) : "side=" + lineSegmentInt.side(this.center) + " center=" + this.center + " seg=" + lineSegmentInt;
            assert (LineSegmentInt.isBetween(this.center, lineSegmentInt.getP1(), lineSegmentInt.getP2()));
            this.addLineSegment(new LineSegmentInt(this.center, lineSegmentInt.getP1()));
            this.addLineSegment(new LineSegmentInt(this.center, lineSegmentInt.getP2()));
        }
        assert (this.betweenZeroAndTwoPi());
    }

    static double convertAngle(double d) {
        if (d < 0.0) {
            return d + Math.PI * 2;
        }
        return d;
    }

    private boolean betweenZeroAndTwoPi() {
        for (Double d : this.angles) {
            assert (d >= 0.0);
            assert (d < Math.PI * 2);
        }
        return true;
    }

    List<Double> getAngles() {
        return new ArrayList<Double>(this.angles);
    }

    public boolean crossing(Point2DInt point2DInt, Point2DInt point2DInt2) {
        boolean bl = this.crossingInternal(point2DInt, point2DInt2);
        assert (bl == this.crossingInternal(point2DInt2, point2DInt));
        return bl;
    }

    private boolean crossingInternal(Point2DInt point2DInt, Point2DInt point2DInt2) {
        if (this.angles.size() < 2) {
            return false;
        }
        double d = Singularity.convertAngle(new LineSegmentInt(this.center, point2DInt).getAngle());
        double d2 = Singularity.convertAngle(new LineSegmentInt(this.center, point2DInt2).getAngle());
        Double d3 = null;
        for (Double d4 : this.angles) {
            if (d3 != null) {
                assert (d3 < d4);
                if (this.isBetween(d, d3, d4) && this.isBetween(d2, d3, d4)) {
                    return false;
                }
            }
            d3 = d4;
        }
        double d5 = this.angles.first();
        return !(d <= d5) && !(d >= d3) || !(d2 <= d5) && !(d2 >= d3);
    }

    private boolean isBetween(double d, double d2, double d3) {
        assert (d2 < d3);
        return d >= d2 && d <= d3;
    }

    protected final Point2DInt getCenter() {
        return this.center;
    }

    public void merge(Singularity singularity) {
        this.angles.addAll(singularity.angles);
    }

    public List<Neighborhood> getNeighborhoods() {
        if (this.angles.size() == 0) {
            return Collections.singletonList(new Neighborhood(this.center));
        }
        ArrayList<Neighborhood> arrayList = new ArrayList<Neighborhood>();
        double d = this.angles.last();
        for (Double d2 : this.angles) {
            arrayList.add(new Neighborhood(this.center, d, d2));
            d = d2;
        }
        return Collections.unmodifiableList(arrayList);
    }
}

