/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.ugraphic.Shadowable;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class TextBlockBordered
extends AbstractTextBlock
implements TextBlock {
    private final double cornersize;
    private final HtmlColor backgroundColor;
    private final HtmlColor borderColor;
    private final int marginX = 6;
    private final int marginY = 5;
    private final UStroke stroke;
    private final boolean withShadow;
    private final TextBlock textBlock;

    TextBlockBordered(TextBlock textBlock, UStroke uStroke, HtmlColor htmlColor, HtmlColor htmlColor2, double d) {
        this.cornersize = d;
        this.textBlock = textBlock;
        this.withShadow = false;
        this.stroke = uStroke;
        this.borderColor = htmlColor;
        this.backgroundColor = htmlColor2;
    }

    private double getTextHeight(StringBounder stringBounder) {
        Dimension2D dimension2D = this.textBlock.calculateDimension(stringBounder);
        return dimension2D.getHeight() + 10.0;
    }

    private double getPureTextWidth(StringBounder stringBounder) {
        Dimension2D dimension2D = this.textBlock.calculateDimension(stringBounder);
        return dimension2D.getWidth();
    }

    private double getTextWidth(StringBounder stringBounder) {
        return this.getPureTextWidth(stringBounder) + 12.0;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double d = this.getTextHeight(stringBounder);
        double d2 = this.getTextWidth(stringBounder);
        return new Dimension2DDouble(d2 + 1.0, d + 1.0);
    }

    private UGraphic applyStroke(UGraphic uGraphic) {
        if (this.stroke == null) {
            return uGraphic;
        }
        return uGraphic.apply(this.stroke);
    }

    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Shadowable shadowable = this.getPolygonNormal(stringBounder);
        if (this.withShadow) {
            shadowable.setDeltaShadow(4.0);
        }
        uGraphic = uGraphic.apply(new UChangeBackColor(this.backgroundColor)).apply(new UChangeColor(this.borderColor));
        uGraphic = this.applyStroke(uGraphic);
        uGraphic.draw(shadowable);
        this.textBlock.drawU(uGraphic.apply(new UTranslate(6.0, 5.0)));
    }

    private Shadowable getPolygonNormal(StringBounder stringBounder) {
        double d = this.getTextHeight(stringBounder);
        double d2 = this.getTextWidth(stringBounder);
        return new URectangle(d2, d, this.cornersize, this.cornersize);
    }
}

