/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.preproc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.net.sourceforge.plantuml.CharSequence2;
import znaishaded.net.sourceforge.plantuml.DefinitionsContainer;
import znaishaded.net.sourceforge.plantuml.FileSystem;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.OptionFlags;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.preproc.Defines;
import znaishaded.net.sourceforge.plantuml.preproc.FileWithSuffix;
import znaishaded.net.sourceforge.plantuml.preproc.ReadLine;
import znaishaded.net.sourceforge.plantuml.preproc.ReadLineList;
import znaishaded.net.sourceforge.plantuml.preproc.ReadLineReader;
import znaishaded.net.sourceforge.plantuml.preproc.ReadLineSimple;
import znaishaded.net.sourceforge.plantuml.preproc.StartDiagramExtractReader;
import znaishaded.net.sourceforge.plantuml.utils.StartUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreprocessorInclude
implements ReadLine {
    private static final Pattern2 includeDefPattern = MyPattern.cmpile("^[%s]*!includedef[%s]+[%g]?([^%g]+)[%g]?$");
    private static final Pattern2 includePattern = MyPattern.cmpile("^[%s]*!include[%s]+[%g]?([^%g]+)[%g]?$");
    private static final Pattern2 includeManyPattern = MyPattern.cmpile("^[%s]*!include_many[%s]+[%g]?([^%g]+)[%g]?$");
    private static final Pattern2 includeURLPattern = MyPattern.cmpile("^[%s]*!includeurl[%s]+[%g]?([^%g]+)[%g]?$");
    private final ReadLine reader2;
    private final String charset;
    private final Defines defines;
    private final DefinitionsContainer definitionsContainer;
    private int numLine = 0;
    private PreprocessorInclude included = null;
    private final File oldCurrentDir;
    private final Set<FileWithSuffix> filesUsedCurrent;
    private final Set<FileWithSuffix> filesUsedGlobal;

    public PreprocessorInclude(ReadLine readLine, Defines defines, String string, File file, DefinitionsContainer definitionsContainer) {
        this(readLine, defines, string, file, new HashSet<FileWithSuffix>(), new HashSet<FileWithSuffix>(), definitionsContainer);
    }

    public Set<FileWithSuffix> getFilesUsedGlobal() {
        return Collections.unmodifiableSet(this.filesUsedGlobal);
    }

    private PreprocessorInclude(ReadLine readLine, Defines defines, String string, File file, Set<FileWithSuffix> set, Set<FileWithSuffix> set2, DefinitionsContainer definitionsContainer) {
        this.defines = defines;
        this.charset = string;
        this.reader2 = readLine;
        this.definitionsContainer = definitionsContainer;
        this.filesUsedCurrent = set;
        this.filesUsedGlobal = set2;
        if (file == null) {
            this.oldCurrentDir = null;
        } else {
            this.oldCurrentDir = FileSystem.getInstance().getCurrentDir();
            FileSystem.getInstance().setCurrentDir(file);
        }
    }

    private void restoreCurrentDir() {
        if (this.oldCurrentDir != null) {
            FileSystem.getInstance().setCurrentDir(this.oldCurrentDir);
        }
    }

    @Override
    public CharSequence2 readLine() throws IOException {
        CharSequence2 charSequence2 = this.readLineInternal();
        if (charSequence2 != null && (StartUtils.isArobaseEndDiagram(charSequence2) || StartUtils.isArobaseStartDiagram(charSequence2))) {
            this.filesUsedCurrent.clear();
        }
        return charSequence2;
    }

    private CharSequence2 readLineInternal() throws IOException {
        Matcher2 matcher2;
        CharSequence2 charSequence2;
        if (this.included != null) {
            charSequence2 = this.included.readLine();
            if (charSequence2 != null) {
                return charSequence2;
            }
            this.included.close();
            this.included = null;
        }
        charSequence2 = this.reader2.readLine();
        ++this.numLine;
        if (charSequence2 == null) {
            return null;
        }
        if (OptionFlags.ALLOW_INCLUDE) {
            assert (this.included == null);
            matcher2 = includePattern.matcher(charSequence2);
            if (matcher2.find()) {
                return this.manageFileInclude(charSequence2, matcher2, false);
            }
            Matcher2 matcher22 = includeManyPattern.matcher(charSequence2);
            if (matcher22.find()) {
                return this.manageFileInclude(charSequence2, matcher22, true);
            }
            Matcher2 matcher23 = includeDefPattern.matcher(charSequence2);
            if (matcher23.find()) {
                return this.manageDefinitionInclude(charSequence2, matcher23);
            }
        }
        matcher2 = includeURLPattern.matcher(charSequence2);
        if (charSequence2.getPreprocessorError() == null && matcher2.find()) {
            return this.manageUrlInclude(charSequence2, matcher2);
        }
        return charSequence2;
    }

    private CharSequence2 manageUrlInclude(CharSequence2 charSequence2, Matcher2 matcher2) throws IOException {
        String string = matcher2.group(1);
        string = this.defines.applyDefines(string).get(0);
        int n = string.lastIndexOf(33);
        String string2 = null;
        if (n != -1) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        try {
            URL uRL = new URL(string);
            this.included = new PreprocessorInclude(this.getReaderInclude(charSequence2, uRL, string2), this.defines, this.charset, null, this.filesUsedCurrent, this.filesUsedGlobal, this.definitionsContainer);
        }
        catch (MalformedURLException malformedURLException) {
            return charSequence2.withErrorPreprocessor("Cannot include url " + string);
        }
        return this.readLine();
    }

    private CharSequence2 manageDefinitionInclude(CharSequence2 charSequence2, Matcher2 matcher2) throws IOException {
        String string = matcher2.group(1);
        List<? extends CharSequence> list = this.definitionsContainer.getDefinition(string);
        this.included = new PreprocessorInclude(new ReadLineList(list, charSequence2.getLocation()), this.defines, this.charset, null, this.filesUsedCurrent, this.filesUsedGlobal, this.definitionsContainer);
        return this.readLine();
    }

    private CharSequence2 manageFileInclude(CharSequence2 charSequence2, Matcher2 matcher2, boolean bl) throws IOException {
        String string = matcher2.group(1);
        string = this.defines.applyDefines(string).get(0);
        int n = string.lastIndexOf(33);
        String string2 = null;
        if (n != -1) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        File file = FileSystem.getInstance().getFile(PreprocessorInclude.withEnvironmentVariable(string));
        FileWithSuffix fileWithSuffix = new FileWithSuffix(file, string2);
        if (!file.exists() || file.isDirectory()) {
            return charSequence2.withErrorPreprocessor("Cannot include " + file.getAbsolutePath());
        }
        if (!bl && this.filesUsedCurrent.contains(fileWithSuffix)) {
            return this.readLine();
        }
        this.filesUsedCurrent.add(fileWithSuffix);
        this.filesUsedGlobal.add(fileWithSuffix);
        this.included = new PreprocessorInclude(this.getReaderInclude(charSequence2, file, string2), this.defines, this.charset, file.getParentFile(), this.filesUsedCurrent, this.filesUsedGlobal, this.definitionsContainer);
        return this.readLine();
    }

    static String withEnvironmentVariable(String string) {
        Pattern pattern = Pattern.compile("%(\\w+)%");
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = PreprocessorInclude.getenv(string2);
            if (string3 == null) continue;
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(string3));
        }
        matcher.appendTail(stringBuffer);
        string = stringBuffer.toString();
        return string;
    }

    public static String getenv(String string) {
        String string2 = System.getProperty(string);
        if (StringUtils.isNotEmpty(string2)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string2);
        }
        String string3 = System.getenv(string);
        if (StringUtils.isNotEmpty(string3)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string3);
        }
        return null;
    }

    private ReadLine getReaderInclude(CharSequence2 charSequence2, File file, String string) {
        try {
            if (StartDiagramExtractReader.containsStartDiagram(charSequence2, file, this.charset)) {
                return new StartDiagramExtractReader(charSequence2, file, string, this.charset);
            }
            if (this.charset == null) {
                Log.info("Using default charset");
                return new ReadLineReader(new FileReader(file), file.getAbsolutePath(), charSequence2.getLocation());
            }
            Log.info("Using charset " + this.charset);
            return new ReadLineReader(new InputStreamReader((InputStream)new FileInputStream(file), this.charset), file.getAbsolutePath(), charSequence2.getLocation());
        }
        catch (IOException iOException) {
            return new ReadLineSimple(charSequence2, iOException.toString());
        }
    }

    private ReadLine getReaderInclude(CharSequence2 charSequence2, URL uRL, String string) {
        try {
            if (StartDiagramExtractReader.containsStartDiagram(charSequence2, uRL, this.charset)) {
                return new StartDiagramExtractReader(charSequence2, uRL, string, this.charset);
            }
            InputStream inputStream = uRL.openStream();
            if (this.charset == null) {
                Log.info("Using default charset");
                return new ReadLineReader(new InputStreamReader(inputStream), uRL.toString(), charSequence2.getLocation());
            }
            Log.info("Using charset " + this.charset);
            return new ReadLineReader(new InputStreamReader(inputStream, this.charset), uRL.toString(), charSequence2.getLocation());
        }
        catch (IOException iOException) {
            return new ReadLineSimple(charSequence2, iOException.toString());
        }
    }

    public int getLineNumber() {
        return this.numLine;
    }

    @Override
    public void close() throws IOException {
        this.restoreCurrentDir();
        this.reader2.close();
    }
}

