/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project2;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorUtils;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.project2.Day;
import znaishaded.net.sourceforge.plantuml.project2.Row;
import znaishaded.net.sourceforge.plantuml.project2.TimeConverter;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class RowSimple
implements Row {
    private static final int HEIGHT = 12;
    private final Day first;
    private final Day last;
    private final HtmlColor backcolor;
    private final TextBlock header;

    public RowSimple(Day day, Day day2) {
        this(day, day2, HtmlColorUtils.BLACK);
    }

    public RowSimple(Day day, Day day2, HtmlColor htmlColor) {
        this(day, day2, htmlColor, TextBlockUtils.empty(0.0, 12.0));
    }

    public RowSimple(Day day, Day day2, HtmlColor htmlColor, TextBlock textBlock) {
        this.first = day;
        this.last = day2;
        this.backcolor = htmlColor;
        if (day2.compareTo(day) < 0) {
            throw new IllegalArgumentException();
        }
        this.header = textBlock;
    }

    public TextBlock asTextBloc(final TimeConverter timeConverter) {
        return new AbstractTextBlock(){

            public void drawU(UGraphic uGraphic) {
                double d = RowSimple.this.getMinXwithoutHeader(timeConverter) + 1.0;
                double d2 = RowSimple.this.getMaxXwithoutHeader(timeConverter) - 1.0;
                double d3 = RowSimple.this.getHeight() - 4.0;
                URectangle uRectangle = new URectangle(d2 - d, d3, 4.0, 4.0);
                uGraphic.apply(new UChangeColor(HtmlColorUtils.RED)).apply(new UChangeBackColor(RowSimple.this.backcolor)).apply(new UTranslate(d, 2.0)).draw(uRectangle);
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                double d = RowSimple.this.getMaxXwithoutHeader(timeConverter) - RowSimple.this.getMinXwithoutHeader(timeConverter);
                double d2 = RowSimple.this.getHeight();
                return new Dimension2DDouble(d, d2);
            }
        };
    }

    public double getMinXwithoutHeader(TimeConverter timeConverter) {
        return timeConverter.getStartPosition(this.first);
    }

    public double getMaxXwithoutHeader(TimeConverter timeConverter) {
        return timeConverter.getEndPosition(this.last);
    }

    public double getHeight() {
        return 12.0;
    }

    public TextBlock header() {
        return this.header;
    }
}

