/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project3;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.AbstractPSystem;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.SpriteContainerEmpty;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorSetSimple;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorUtils;
import znaishaded.net.sourceforge.plantuml.graphic.IHtmlColorSet;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.UDrawable;
import znaishaded.net.sourceforge.plantuml.project3.DayAsDate;
import znaishaded.net.sourceforge.plantuml.project3.GCalendar;
import znaishaded.net.sourceforge.plantuml.project3.GCalendarSimple;
import znaishaded.net.sourceforge.plantuml.project3.GanttConstraint;
import znaishaded.net.sourceforge.plantuml.project3.Instant;
import znaishaded.net.sourceforge.plantuml.project3.InstantDay;
import znaishaded.net.sourceforge.plantuml.project3.Month;
import znaishaded.net.sourceforge.plantuml.project3.Subject;
import znaishaded.net.sourceforge.plantuml.project3.Task;
import znaishaded.net.sourceforge.plantuml.project3.TaskCode;
import znaishaded.net.sourceforge.plantuml.project3.TaskCodeSimpleOrder;
import znaishaded.net.sourceforge.plantuml.project3.TaskDraw;
import znaishaded.net.sourceforge.plantuml.project3.TaskImpl;
import znaishaded.net.sourceforge.plantuml.project3.TimeScale;
import znaishaded.net.sourceforge.plantuml.project3.TimeScaleBasic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import znaishaded.net.sourceforge.plantuml.ugraphic.ImageBuilder;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class GanttDiagram
extends AbstractPSystem
implements Subject {
    private final Map<TaskCode, Task> tasks = new LinkedHashMap<TaskCode, Task>();
    private final Map<String, Task> byShortName = new HashMap<String, Task>();
    private final List<GanttConstraint> constraints = new ArrayList<GanttConstraint>();
    private final IHtmlColorSet colorSet = new HtmlColorSetSimple();
    private GCalendar calendar;
    private Instant min;
    private Instant max;

    public DiagramDescription getDescription() {
        return new DiagramDescription("(Project)");
    }

    protected ImageData exportDiagramNow(OutputStream outputStream, int n, FileFormatOption fileFormatOption, long l) throws IOException {
        this.sortTasks();
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, null, "", "", 0.0, 0.0, null, false);
        imageBuilder.setUDrawable(this.getUDrawable());
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, l, outputStream);
    }

    private void sortTasks() {
        final TaskCodeSimpleOrder taskCodeSimpleOrder = this.getCanonicalOrder(1);
        ArrayList<Task> arrayList = new ArrayList<Task>(this.tasks.values());
        Collections.sort(arrayList, new Comparator<Task>(){

            @Override
            public int compare(Task task, Task task2) {
                return taskCodeSimpleOrder.compare(task.getCode(), task2.getCode());
            }
        });
        this.tasks.clear();
        for (Task task : arrayList) {
            this.tasks.put(task.getCode(), task);
        }
    }

    private UDrawable getUDrawable() {
        return new UDrawable(){

            public void drawU(UGraphic uGraphic) {
                GanttDiagram.this.initMinMax();
                TimeScale timeScale = GanttDiagram.this.getTimeScale();
                GanttDiagram.this.drawTimeHeader(uGraphic, timeScale);
                GanttDiagram.this.drawTasks(uGraphic, timeScale);
                GanttDiagram.this.drawConstraints(uGraphic, timeScale);
            }
        };
    }

    private TimeScale getTimeScale() {
        return new TimeScaleBasic();
    }

    private void drawConstraints(UGraphic uGraphic, TimeScale timeScale) {
        for (GanttConstraint ganttConstraint : this.constraints) {
            ganttConstraint.getUDrawable(timeScale).drawU(uGraphic);
        }
    }

    private void drawTimeHeader(UGraphic uGraphic, TimeScale timeScale) {
        double d = this.initTaskDraws(timeScale);
        double d2 = timeScale.getStartingPosition(this.min);
        double d3 = timeScale.getStartingPosition(this.max.increment());
        uGraphic.apply(new UChangeColor(HtmlColorUtils.LIGHT_GRAY)).draw(new ULine(d3 - d2, 0.0));
        uGraphic.apply(new UChangeColor(HtmlColorUtils.LIGHT_GRAY)).apply(new UTranslate(0.0, this.getHeaderHeight() - 3.0)).draw(new ULine(d3 - d2, 0.0));
        if (this.calendar == null) {
            this.drawSimpleDayCounter(uGraphic, timeScale, d);
        } else {
            this.drawCalendar(uGraphic, timeScale, d);
        }
    }

    private void drawCalendar(UGraphic uGraphic, TimeScale timeScale, double d) {
        ULine uLine = new ULine(0.0, d - 12.0);
        Month month = null;
        Instant instant = this.min;
        while (instant.compareTo(this.max.increment()) <= 0) {
            DayAsDate dayAsDate = this.calendar.toDayAsDate((InstantDay)instant);
            String string = "" + dayAsDate.getDayOfMonth();
            TextBlock textBlock = Display.getWithNewlines(string).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            double d2 = timeScale.getStartingPosition(instant);
            double d3 = timeScale.getStartingPosition(instant.increment());
            if (instant.compareTo(this.max.increment()) < 0) {
                TextBlock textBlock2 = Display.getWithNewlines(dayAsDate.getDayOfWeek().shortName()).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
                this.drawCenter(uGraphic.apply(new UTranslate(0.0, 24.0)), textBlock, d2, d3);
                this.drawCenter(uGraphic.apply(new UTranslate(0.0, 12.0)), textBlock2, d2, d3);
                if (month != dayAsDate.getMonth()) {
                    TextBlock textBlock3 = Display.getWithNewlines(dayAsDate.getMonth().name()).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
                    textBlock3.drawU(uGraphic.apply(new UTranslate(d2, 0.0)));
                }
                month = dayAsDate.getMonth();
            }
            uGraphic.apply(new UChangeColor(HtmlColorUtils.LIGHT_GRAY)).apply(new UTranslate(d2, 12.0)).draw(uLine);
            instant = instant.increment();
        }
    }

    private double getHeaderHeight() {
        if (this.calendar != null) {
            return 40.0;
        }
        return 16.0;
    }

    private void drawCenter(UGraphic uGraphic, TextBlock textBlock, double d, double d2) {
        double d3 = textBlock.calculateDimension(uGraphic.getStringBounder()).getWidth();
        double d4 = d2 - d - d3;
        if (d4 < 0.0) {
            return;
        }
        textBlock.drawU(uGraphic.apply(new UTranslate(d + d4 / 2.0, 0.0)));
    }

    private void drawSimpleDayCounter(UGraphic uGraphic, TimeScale timeScale, double d) {
        ULine uLine = new ULine(0.0, d);
        Instant instant = this.min;
        while (instant.compareTo(this.max.increment()) <= 0) {
            TextBlock textBlock = Display.getWithNewlines(instant.toShortString()).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            double d2 = timeScale.getStartingPosition(instant);
            double d3 = timeScale.getStartingPosition(instant.increment());
            double d4 = textBlock.calculateDimension(uGraphic.getStringBounder()).getWidth();
            double d5 = d3 - d2 - d4;
            if (instant.compareTo(this.max.increment()) < 0) {
                textBlock.drawU(uGraphic.apply(new UTranslate(d2 + d5 / 2.0, 0.0)));
            }
            uGraphic.apply(new UChangeColor(HtmlColorUtils.LIGHT_GRAY)).apply(new UTranslate(d2, 0.0)).draw(uLine);
            instant = instant.increment();
        }
    }

    private double initTaskDraws(TimeScale timeScale) {
        double d = this.getHeaderHeight();
        for (Task task : this.tasks.values()) {
            TaskDraw taskDraw = new TaskDraw(task, timeScale, d);
            task.setTaskDraw(taskDraw);
            d += taskDraw.getHeight();
        }
        return d;
    }

    private void initMinMax() {
        this.min = this.tasks.values().iterator().next().getStart();
        this.max = this.tasks.values().iterator().next().getEnd();
        for (Task task : this.tasks.values()) {
            Instant instant = task.getStart();
            Instant instant2 = task.getEnd();
            if (this.min.compareTo(instant) > 0) {
                this.min = instant;
            }
            if (this.max.compareTo(instant2) >= 0) continue;
            this.max = instant2;
        }
    }

    private void drawTasks(UGraphic uGraphic, TimeScale timeScale) {
        for (Task task : this.tasks.values()) {
            TaskDraw taskDraw = task.getTaskDraw();
            taskDraw.drawU(uGraphic.apply(new UTranslate(0.0, taskDraw.getY())));
            taskDraw.getTitle().drawU(uGraphic.apply(new UTranslate(timeScale.getStartingPosition(task.getStart().increment()), taskDraw.getY())));
        }
    }

    private FontConfiguration getFontConfiguration() {
        UFont uFont = UFont.serif(10);
        return new FontConfiguration(uFont, HtmlColorUtils.LIGHT_GRAY, HtmlColorUtils.LIGHT_GRAY, false);
    }

    public Task getExistingTask(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        Task task = this.byShortName.get(string);
        if (task != null) {
            return task;
        }
        TaskCode taskCode = new TaskCode(string);
        return this.tasks.get(taskCode);
    }

    public Task getOrCreateTask(String string, String string2) {
        Task task;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        Task task2 = task = string2 == null ? null : this.byShortName.get(string2);
        if (task != null) {
            return task;
        }
        task = this.byShortName.get(string);
        if (task != null) {
            return task;
        }
        TaskCode taskCode = new TaskCode(string);
        task = this.tasks.get(taskCode);
        if (task == null) {
            task = new TaskImpl(taskCode);
            this.tasks.put(taskCode, task);
            if (this.byShortName != null) {
                this.byShortName.put(string2, task);
            }
        }
        return task;
    }

    private TaskCodeSimpleOrder getCanonicalOrder(int n) {
        ArrayList<TaskCode> arrayList = new ArrayList<TaskCode>();
        for (TaskCode taskCode : this.tasks.keySet()) {
            if (taskCode.getHierarchySize() < n) continue;
            arrayList.add(taskCode.truncateHierarchy(n));
        }
        return new TaskCodeSimpleOrder(arrayList, n);
    }

    private int getMaxHierarchySize() {
        int n = Integer.MIN_VALUE;
        for (TaskCode taskCode : this.tasks.keySet()) {
            n = Math.max(n, taskCode.getHierarchySize());
        }
        return n;
    }

    public void addContraint(GanttConstraint ganttConstraint) {
        this.constraints.add(ganttConstraint);
    }

    public IHtmlColorSet getIHtmlColorSet() {
        return this.colorSet;
    }

    public void setStartingDate(DayAsDate dayAsDate) {
        this.calendar = new GCalendarSimple(dayAsDate);
    }
}

