/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project3;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.project3.Duration;
import znaishaded.net.sourceforge.plantuml.project3.Instant;
import znaishaded.net.sourceforge.plantuml.project3.TaskAttribute;
import znaishaded.net.sourceforge.plantuml.project3.Value;

public class Solver {
    private final Map<TaskAttribute, Value> values = new LinkedHashMap<TaskAttribute, Value>();

    public void setData(TaskAttribute taskAttribute, Value value) {
        this.values.remove((Object)taskAttribute);
        this.values.put(taskAttribute, value);
        if (this.values.size() > 2) {
            this.removeFirstElement();
        }
        assert (this.values.size() <= 2);
    }

    private void removeFirstElement() {
        Iterator<Map.Entry<TaskAttribute, Value>> iterator = this.values.entrySet().iterator();
        iterator.next();
        iterator.remove();
    }

    public Value getData(TaskAttribute taskAttribute) {
        Value value = this.values.get((Object)taskAttribute);
        if (value == null) {
            if (taskAttribute == TaskAttribute.END) {
                return this.computeEnd();
            }
            if (taskAttribute == TaskAttribute.START) {
                return this.computeStart();
            }
            throw new UnsupportedOperationException(taskAttribute.toString());
        }
        return value;
    }

    private Instant computeStart() {
        Instant instant = (Instant)this.values.get((Object)TaskAttribute.END);
        Duration duration = (Duration)this.values.get((Object)TaskAttribute.DURATION);
        assert (instant != null && duration != null);
        return instant.sub(duration).increment();
    }

    private Instant computeEnd() {
        Instant instant = (Instant)this.values.get((Object)TaskAttribute.START);
        Duration duration = (Duration)this.values.get((Object)TaskAttribute.DURATION);
        assert (instant != null && duration != null);
        return instant.add(duration).decrement();
    }
}

