/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.VerticalAlignment;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LivingSpaces {
    private final Map<Participant, LivingSpace> all = new LinkedHashMap<Participant, LivingSpace>();

    public Collection<LivingSpace> values() {
        return this.all.values();
    }

    public void addConstraints(StringBounder stringBounder) {
        LivingSpace livingSpace = null;
        for (LivingSpace livingSpace2 : this.all.values()) {
            if (livingSpace != null) {
                Real real = livingSpace.getPosD(stringBounder);
                Real real2 = livingSpace2.getPosB();
                real2.ensureBiggerThan(real.addFixed(10.0));
            }
            livingSpace = livingSpace2;
        }
    }

    public LivingSpace previous(LivingSpace livingSpace) {
        LivingSpace livingSpace2 = null;
        for (LivingSpace livingSpace3 : this.all.values()) {
            if (livingSpace3 == livingSpace) {
                return livingSpace2;
            }
            livingSpace2 = livingSpace3;
        }
        return null;
    }

    public LivingSpace next(LivingSpace livingSpace) {
        Iterator<LivingSpace> iterator = this.all.values().iterator();
        while (iterator.hasNext()) {
            LivingSpace livingSpace2 = iterator.next();
            if (livingSpace2 != livingSpace || !iterator.hasNext()) continue;
            return iterator.next();
        }
        return null;
    }

    public Collection<Participant> participants() {
        return this.all.keySet();
    }

    public void put(Participant participant, LivingSpace livingSpace) {
        this.all.put(participant, livingSpace);
    }

    public LivingSpace get(Participant participant) {
        return this.all.get(participant);
    }

    public void drawHeads(UGraphic uGraphic, Context2D context2D, VerticalAlignment verticalAlignment) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d = this.getHeadHeight(stringBounder);
        for (LivingSpace livingSpace : this.values()) {
            double d2 = livingSpace.getPosB().getCurrentValue();
            double d3 = 0.0;
            if (verticalAlignment == VerticalAlignment.BOTTOM) {
                Dimension2D dimension2D = livingSpace.getHeadPreferredDimension(stringBounder);
                d3 = d - dimension2D.getHeight();
            }
            livingSpace.drawHead(uGraphic.apply(new UTranslate(d2, d3)), context2D, verticalAlignment, HorizontalAlignment.LEFT);
        }
    }

    public double getHeadHeight(StringBounder stringBounder) {
        double d = 0.0;
        for (LivingSpace livingSpace : this.values()) {
            Dimension2D dimension2D = livingSpace.getHeadPreferredDimension(stringBounder);
            d = Math.max(d, dimension2D.getHeight());
        }
        return d;
    }

    public void drawLifeLines(UGraphic uGraphic, double d, Context2D context2D) {
        boolean bl = false;
        for (LivingSpace livingSpace : this.values()) {
            double d2 = livingSpace.getPosC(uGraphic.getStringBounder()).getCurrentValue();
            livingSpace.drawLineAndLiveBoxes(uGraphic.apply(new UTranslate(d2, 0.0)), d, context2D);
        }
    }

    public void delayOn(double d, double d2) {
        for (LivingSpace livingSpace : this.values()) {
            livingSpace.delayOn(d, d2);
        }
    }

    public int size() {
        return this.all.size();
    }
}

