/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.net.sourceforge.plantuml.BaseFile;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.Pragma;
import znaishaded.net.sourceforge.plantuml.SkinParamForecolored;
import znaishaded.net.sourceforge.plantuml.SkinParamSameClassWidth;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.UmlDiagramType;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Code;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.EntityPortion;
import znaishaded.net.sourceforge.plantuml.cucadiagram.EntityPosition;
import znaishaded.net.sourceforge.plantuml.cucadiagram.GroupType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IEntity;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IGroup;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LeafType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Link;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Member;
import znaishaded.net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import znaishaded.net.sourceforge.plantuml.cucadiagram.PortionShower;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.cucadiagram.UnparsableGraphvizException;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.DotData;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.ExeState;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.Neighborhood;
import znaishaded.net.sourceforge.plantuml.cucadiagram.entity.EntityFactory;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.GraphicStrings;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorUtils;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockEmpty;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.USymbol;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.svek.Bibliotekon;
import znaishaded.net.sourceforge.plantuml.svek.Cluster;
import znaishaded.net.sourceforge.plantuml.svek.ClusterPosition;
import znaishaded.net.sourceforge.plantuml.svek.DotStringFactory;
import znaishaded.net.sourceforge.plantuml.svek.EntityImageProtected;
import znaishaded.net.sourceforge.plantuml.svek.GraphvizCrash;
import znaishaded.net.sourceforge.plantuml.svek.IEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.Line;
import znaishaded.net.sourceforge.plantuml.svek.Shape;
import znaishaded.net.sourceforge.plantuml.svek.SvekResult;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageActivity;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageArcCircle;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageAssociation;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageAssociationPoint;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageBranch;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageCircleEnd;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageCircleStart;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageClass;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageDescription;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageEmptyPackage;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageGroup;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageLollipopInterface;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageNote;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageObject;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImagePseudoState;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageState;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageState2;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageStateBorder;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageStateEmptyDescription;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageSynchroBar;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageTips;
import znaishaded.net.sourceforge.plantuml.svek.image.EntityImageUseCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DotDataImageBuilder {
    private final DotData dotData;
    private final EntityFactory entityFactory;
    private final UmlSource source;
    private final Pragma pragma;
    private Map<Code, Double> maxX;
    private final StringBounder stringBounder;

    public DotDataImageBuilder(DotData dotData, EntityFactory entityFactory, UmlSource umlSource, Pragma pragma, StringBounder stringBounder) {
        this.dotData = dotData;
        this.entityFactory = entityFactory;
        this.source = umlSource;
        this.pragma = pragma;
        this.stringBounder = stringBounder;
    }

    public IEntityImage buildImage(BaseFile baseFile, String[] stringArray) {
        String string;
        Object illegalStateException;
        this.dotData.removeIrrelevantSametail();
        DotStringFactory dotStringFactory = new DotStringFactory(this.stringBounder, this.dotData);
        this.printGroups(dotStringFactory, this.dotData.getRootGroup());
        this.printEntities(dotStringFactory, this.getUnpackagedEntities());
        for (Link object22 : this.dotData.getLinks()) {
            if (object22.isRemoved()) continue;
            try {
                Shape shape;
                Shape d2;
                illegalStateException = this.dotData.getSkinParam();
                FontConfiguration d = new FontConfiguration((ISkinParam)illegalStateException, FontParam.ARROW, null);
                Line line = new Line(object22, dotStringFactory.getColorSequence(), (ISkinParam)illegalStateException, this.stringBounder, d, dotStringFactory.getBibliotekon(), this.dotData.getPragma());
                dotStringFactory.getBibliotekon().addLine(line);
                if (!object22.getEntity1().isGroup() && object22.getEntity1().getLeafType() == LeafType.NOTE && this.onlyOneLink(object22.getEntity1())) {
                    d2 = dotStringFactory.getBibliotekon().getShape(object22.getEntity1());
                    shape = dotStringFactory.getBibliotekon().getShape(object22.getEntity2());
                    if (shape == null) continue;
                    ((EntityImageNote)d2.getImage()).setOpaleLine(line, d2, shape);
                    line.setOpale(true);
                    continue;
                }
                if (object22.getEntity2().isGroup() || object22.getEntity2().getLeafType() != LeafType.NOTE || !this.onlyOneLink(object22.getEntity2())) continue;
                d2 = dotStringFactory.getBibliotekon().getShape(object22.getEntity2());
                shape = dotStringFactory.getBibliotekon().getShape(object22.getEntity1());
                if (shape == null) continue;
                ((EntityImageNote)d2.getImage()).setOpaleLine(line, d2, shape);
                line.setOpale(true);
            }
            catch (IllegalStateException exception) {
                exception.printStackTrace();
            }
        }
        if (dotStringFactory.illegalDotExe()) {
            return this.error(dotStringFactory.getDotExe());
        }
        if (baseFile == null && this.isSvekTrace()) {
            baseFile = new BaseFile();
        }
        try {
            string = dotStringFactory.getSvg(baseFile, stringArray);
        }
        catch (IOException iOException) {
            return new GraphvizCrash(this.source.getPlainString());
        }
        if (string.length() == 0) {
            return new GraphvizCrash(this.source.getPlainString());
        }
        String string2 = this.extractGraphvizVersion(string);
        try {
            illegalStateException = dotStringFactory.solve(string).delta(10.0, 10.0);
            double d = ((ClusterPosition)illegalStateException).getMinY();
            double d2 = ((ClusterPosition)illegalStateException).getMinX();
            if (d2 > 0.0 || d > 0.0) {
                throw new IllegalStateException();
            }
            SvekResult svekResult = new SvekResult((ClusterPosition)illegalStateException, this.dotData, dotStringFactory);
            svekResult.moveSvek(6.0 - d2, -d);
            this.maxX = dotStringFactory.getBibliotekon().getMaxX();
            return svekResult;
        }
        catch (Exception exception) {
            Log.error("Exception " + exception);
            throw new UnparsableGraphvizException(exception, string2, string, this.source.getPlainString());
        }
    }

    private boolean isSvekTrace() {
        String string = this.pragma.getValue("svek_trace");
        return "true".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string);
    }

    private String extractGraphvizVersion(String string) {
        Pattern pattern = Pattern.compile("(?mi)!-- generated by graphviz(.*)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return StringUtils.trin(matcher.group(1));
        }
        return null;
    }

    private boolean onlyOneLink(IEntity iEntity) {
        int n = 0;
        for (Link link : this.dotData.getLinks()) {
            if (link.isInvis()) continue;
            if (link.contains(iEntity)) {
                ++n;
            }
            if (n <= 1) continue;
            return false;
        }
        return n == 1;
    }

    private IEntityImage error(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Dot Executable: " + file);
        ExeState exeState = ExeState.checkFile(file);
        arrayList.add(exeState.getTextMessage());
        arrayList.add("Cannot find Graphviz. You should try");
        arrayList.add(" ");
        arrayList.add("@startuml");
        arrayList.add("testdot");
        arrayList.add("@enduml");
        arrayList.add(" ");
        arrayList.add(" or ");
        arrayList.add(" ");
        arrayList.add("java -jar plantuml.jar -testdot");
        arrayList.add(" ");
        return GraphicStrings.createForError(arrayList, false);
    }

    private void printEntities(DotStringFactory dotStringFactory, Collection<ILeaf> collection) {
        for (ILeaf iLeaf : collection) {
            if (iLeaf.isRemoved()) continue;
            this.printEntity(dotStringFactory, iLeaf);
        }
    }

    private void printEntity(DotStringFactory dotStringFactory, ILeaf iLeaf) {
        if (iLeaf.isRemoved()) {
            throw new IllegalStateException();
        }
        IEntityImage iEntityImage = this.printEntityInternal(dotStringFactory, iLeaf);
        Dimension2D dimension2D = iEntityImage.calculateDimension(this.stringBounder);
        Shape shape = new Shape(iEntityImage, iEntityImage.getShapeType(), dimension2D.getWidth(), dimension2D.getHeight(), dotStringFactory.getColorSequence(), iLeaf.isTop(), iEntityImage.getShield(this.stringBounder), iLeaf.getEntityPosition());
        dotStringFactory.addShape(shape);
        dotStringFactory.getBibliotekon().putShape(iLeaf, shape);
    }

    private IEntityImage printEntityInternal(DotStringFactory dotStringFactory, ILeaf iLeaf) {
        if (iLeaf.isRemoved()) {
            throw new IllegalStateException();
        }
        if (iLeaf.getSvekImage() == null) {
            ISkinParam iSkinParam = this.dotData.getSkinParam();
            if (iSkinParam.sameClassWidth()) {
                double d = this.getMaxWidth(dotStringFactory);
                iSkinParam = new SkinParamSameClassWidth(iSkinParam, d);
            }
            return DotDataImageBuilder.createEntityImageBlock(iLeaf, iSkinParam, this.dotData.isHideEmptyDescriptionForState(), this.dotData, dotStringFactory.getBibliotekon(), dotStringFactory.getGraphvizVersion(), this.dotData.getUmlDiagramType(), this.dotData.getLinks());
        }
        return iLeaf.getSvekImage();
    }

    private double getMaxWidth(DotStringFactory dotStringFactory) {
        double d = 0.0;
        for (ILeaf iLeaf : this.dotData.getLeafs()) {
            EntityImageClass entityImageClass;
            double d2;
            if (!iLeaf.getLeafType().isLikeClass() || !((d2 = (entityImageClass = new EntityImageClass(dotStringFactory.getGraphvizVersion(), iLeaf, this.dotData.getSkinParam(), this.dotData)).calculateDimension(this.stringBounder).getWidth()) > d)) continue;
            d = d2;
        }
        return d;
    }

    public static IEntityImage createEntityImageBlock(ILeaf iLeaf, ISkinParam iSkinParam, boolean bl, PortionShower portionShower, Bibliotekon bibliotekon, GraphvizVersion graphvizVersion, UmlDiagramType umlDiagramType, Collection<Link> collection) {
        if (iLeaf.isRemoved()) {
            throw new IllegalStateException();
        }
        if (iLeaf.getLeafType().isLikeClass()) {
            EntityImageClass entityImageClass = new EntityImageClass(graphvizVersion, iLeaf, iSkinParam, portionShower);
            Neighborhood neighborhood = iLeaf.getNeighborhood();
            if (neighborhood != null) {
                return new EntityImageProtected(entityImageClass, 20.0, neighborhood, bibliotekon);
            }
            return entityImageClass;
        }
        if (iLeaf.getLeafType() == LeafType.NOTE) {
            return new EntityImageNote(iLeaf, iSkinParam);
        }
        if (iLeaf.getLeafType() == LeafType.ACTIVITY) {
            return new EntityImageActivity(iLeaf, iSkinParam, bibliotekon);
        }
        if (iLeaf.getLeafType() == LeafType.STATE) {
            if (iLeaf.getEntityPosition() != EntityPosition.NORMAL) {
                Cluster cluster = bibliotekon.getCluster(iLeaf.getParentContainer());
                return new EntityImageStateBorder(iLeaf, iSkinParam, cluster, bibliotekon);
            }
            if (bl && iLeaf.getBodier().getFieldsToDisplay().size() == 0) {
                return new EntityImageStateEmptyDescription(iLeaf, iSkinParam);
            }
            if (iLeaf.getStereotype() != null && "<<sdlreceive>>".equals(iLeaf.getStereotype().getLabel(false))) {
                return new EntityImageState2(iLeaf, iSkinParam);
            }
            return new EntityImageState(iLeaf, iSkinParam);
        }
        if (iLeaf.getLeafType() == LeafType.CIRCLE_START) {
            ColorParam colorParam = ColorParam.activityStart;
            if (umlDiagramType == UmlDiagramType.STATE) {
                colorParam = ColorParam.stateStart;
            }
            return new EntityImageCircleStart(iLeaf, iSkinParam, colorParam);
        }
        if (iLeaf.getLeafType() == LeafType.CIRCLE_END) {
            ColorParam colorParam = ColorParam.activityEnd;
            if (umlDiagramType == UmlDiagramType.STATE) {
                colorParam = ColorParam.stateEnd;
            }
            return new EntityImageCircleEnd(iLeaf, iSkinParam, colorParam);
        }
        if (iLeaf.getLeafType() == LeafType.BRANCH || iLeaf.getLeafType() == LeafType.STATE_CHOICE) {
            return new EntityImageBranch(iLeaf, iSkinParam);
        }
        if (iLeaf.getLeafType() == LeafType.LOLLIPOP) {
            return new EntityImageLollipopInterface(iLeaf, iSkinParam);
        }
        if (iLeaf.getLeafType() == LeafType.CIRCLE) {
            return new EntityImageDescription(iLeaf, iSkinParam, portionShower, collection);
        }
        if (iLeaf.getLeafType() == LeafType.DESCRIPTION) {
            return new EntityImageDescription(iLeaf, iSkinParam, portionShower, collection);
        }
        if (iLeaf.getLeafType() == LeafType.USECASE) {
            return new EntityImageUseCase(iLeaf, iSkinParam);
        }
        if (iLeaf.getLeafType() == LeafType.OBJECT) {
            return new EntityImageObject(iLeaf, iSkinParam, portionShower);
        }
        if (iLeaf.getLeafType() == LeafType.SYNCHRO_BAR || iLeaf.getLeafType() == LeafType.STATE_FORK_JOIN) {
            return new EntityImageSynchroBar(iLeaf, iSkinParam);
        }
        if (iLeaf.getLeafType() == LeafType.ARC_CIRCLE) {
            return new EntityImageArcCircle(iLeaf, iSkinParam);
        }
        if (iLeaf.getLeafType() == LeafType.POINT_FOR_ASSOCIATION) {
            return new EntityImageAssociationPoint(iLeaf, iSkinParam);
        }
        if (iLeaf.isGroup()) {
            return new EntityImageGroup(iLeaf, iSkinParam);
        }
        if (iLeaf.getLeafType() == LeafType.EMPTY_PACKAGE) {
            if (iLeaf.getUSymbol() != null) {
                return new EntityImageDescription(iLeaf, new SkinParamForecolored(iSkinParam, HtmlColorUtils.BLACK), portionShower, collection);
            }
            return new EntityImageEmptyPackage(iLeaf, iSkinParam, portionShower);
        }
        if (iLeaf.getLeafType() == LeafType.ASSOCIATION) {
            return new EntityImageAssociation(iLeaf, iSkinParam);
        }
        if (iLeaf.getLeafType() == LeafType.PSEUDO_STATE) {
            return new EntityImagePseudoState(iLeaf, iSkinParam);
        }
        if (iLeaf.getLeafType() == LeafType.TIPS) {
            return new EntityImageTips(iLeaf, iSkinParam, bibliotekon);
        }
        throw new UnsupportedOperationException(iLeaf.getLeafType().toString());
    }

    private Collection<ILeaf> getUnpackagedEntities() {
        ArrayList<ILeaf> arrayList = new ArrayList<ILeaf>();
        for (ILeaf iLeaf : this.dotData.getLeafs()) {
            if (this.dotData.getTopParent() != iLeaf.getParentContainer()) continue;
            arrayList.add(iLeaf);
        }
        return arrayList;
    }

    private void printGroups(DotStringFactory dotStringFactory, IGroup iGroup) {
        for (IGroup iGroup2 : this.dotData.getGroupHierarchy().getChildrenGroups(iGroup)) {
            if (iGroup2.isRemoved()) continue;
            if (this.dotData.isEmpty(iGroup2) && iGroup2.getGroupType() == GroupType.PACKAGE) {
                ILeaf iLeaf = this.entityFactory.createLeaf(iGroup2.getCode(), iGroup2.getDisplay(), LeafType.EMPTY_PACKAGE, iGroup2.getParentContainer(), null, this.dotData.getNamespaceSeparator());
                USymbol uSymbol = iGroup2.getUSymbol();
                iLeaf.setUSymbol(uSymbol);
                iLeaf.setStereotype(iGroup2.getStereotype());
                if (iGroup2.getUrl99() != null) {
                    iLeaf.addUrl(iGroup2.getUrl99());
                }
                if (iGroup2.getColors(this.dotData.getSkinParam()).getColor(ColorType.BACK) == null) {
                    ColorParam colorParam = uSymbol == null ? ColorParam.packageBackground : uSymbol.getColorParamBack();
                    HtmlColor htmlColor = this.dotData.getSkinParam().getHtmlColor(colorParam, iGroup2.getStereotype(), false);
                    iLeaf.setSpecificColorTOBEREMOVED(ColorType.BACK, htmlColor == null ? this.dotData.getSkinParam().getBackgroundColor() : htmlColor);
                } else {
                    iLeaf.setSpecificColorTOBEREMOVED(ColorType.BACK, iGroup2.getColors(this.dotData.getSkinParam()).getColor(ColorType.BACK));
                }
                this.printEntity(dotStringFactory, iLeaf);
                continue;
            }
            this.printGroup(dotStringFactory, iGroup2);
        }
    }

    private void printGroup(DotStringFactory dotStringFactory, IGroup iGroup) {
        if (iGroup.getGroupType() == GroupType.CONCURRENT_STATE) {
            return;
        }
        int n = 0;
        int n2 = 0;
        TextBlock textBlock = this.getTitleBlock(iGroup);
        TextBlock textBlock2 = this.getStereoBlock(iGroup);
        TextBlock textBlock3 = TextBlockUtils.mergeTB(textBlock2, textBlock, HorizontalAlignment.CENTER);
        Dimension2D dimension2D = textBlock3.calculateDimension(this.stringBounder);
        if (dimension2D.getWidth() > 0.0) {
            List<Member> list = iGroup.getBodier().getFieldsToDisplay();
            AbstractTextBlock abstractTextBlock = list.size() == 0 ? new TextBlockEmpty() : new MethodsOrFieldsArea(list, FontParam.STATE_ATTRIBUTE, this.dotData.getSkinParam(), iGroup.getStereotype(), null);
            Dimension2D dimension2D2 = abstractTextBlock.calculateDimension(this.stringBounder);
            double d = dimension2D2.getHeight();
            double d2 = dimension2D2.getWidth();
            double d3 = d > 0.0 ? 5.0 : 0.0;
            USymbol uSymbol = iGroup.getUSymbol();
            int n3 = uSymbol == null ? 0 : uSymbol.suppHeightBecauseOfShape();
            int n4 = uSymbol == null ? 0 : uSymbol.suppWidthBecauseOfShape();
            n = (int)Math.max(dimension2D.getWidth(), d2) + n4;
            n2 = (int)(dimension2D.getHeight() + d + d3 + (double)n3);
        }
        dotStringFactory.openCluster(iGroup, n, n2, textBlock, textBlock2);
        this.printEntities(dotStringFactory, iGroup.getLeafsDirect());
        this.printGroups(dotStringFactory, iGroup);
        dotStringFactory.closeCluster();
    }

    private TextBlock getTitleBlock(IGroup iGroup) {
        Display display = iGroup.getDisplay();
        if (display == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        ISkinParam iSkinParam = this.dotData.getSkinParam();
        FontConfiguration fontConfiguration = iGroup.getFontConfigurationForTitle(iSkinParam);
        return display.create(fontConfiguration, HorizontalAlignment.CENTER, iSkinParam);
    }

    private TextBlock getStereoBlock(IGroup iGroup) {
        List<String> list;
        Stereotype stereotype = iGroup.getStereotype();
        if (stereotype == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        if (stereotype.getSprite() != null && (list = this.dotData.getSkinParam().getSprite(stereotype.getSprite())) != null) {
            return list.asTextBlock(stereotype.getHtmlColor(), 1.0);
        }
        list = stereotype.getLabels(this.dotData.getSkinParam().useGuillemet());
        if (list == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        boolean bl = this.dotData.showPortion(EntityPortion.STEREOTYPE, iGroup);
        if (!bl) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        FontParam fontParam = FontParam.PACKAGE_STEREOTYPE;
        return Display.create((Collection<? extends CharSequence>)list).create(new FontConfiguration(this.dotData.getSkinParam(), fontParam, stereotype), HorizontalAlignment.CENTER, this.dotData.getSkinParam());
    }

    public String getWarningOrError(int n) {
        if (this.maxX == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<Code, Double> entry : this.maxX.entrySet()) {
            if (!(entry.getValue() > (double)n)) continue;
            stringBuilder.append(entry.getKey() + " is overpassing the width limit.");
            stringBuilder.append("\n");
        }
        return stringBuilder.length() == 0 ? "" : stringBuilder.toString();
    }
}

