/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.LineParam;
import znaishaded.net.sourceforge.plantuml.SkinParamUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.creole.Stencil;
import znaishaded.net.sourceforge.plantuml.cucadiagram.BodyEnhanced;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.ugraphic.AbstractUGraphicHorizontalLine;
import znaishaded.net.sourceforge.plantuml.ugraphic.TextBlockInEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UHorizontalLine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageUseCase
extends AbstractEntityImage {
    private final TextBlock desc;
    private final Url url;

    public EntityImageUseCase(ILeaf iLeaf, ISkinParam iSkinParam) {
        super(iLeaf, iSkinParam);
        Stereotype stereotype = iLeaf.getStereotype();
        BodyEnhanced bodyEnhanced = new BodyEnhanced(iLeaf.getDisplay(), FontParam.USECASE, iSkinParam, HorizontalAlignment.CENTER, stereotype, true, false, iLeaf);
        if (stereotype == null || stereotype.getLabel(false) == null) {
            this.desc = bodyEnhanced;
        } else {
            TextBlock textBlock = Display.getWithNewlines(stereotype.getLabel(this.getSkinParam().useGuillemet())).create(new FontConfiguration(this.getSkinParam(), FontParam.USECASE_STEREOTYPE, stereotype), HorizontalAlignment.CENTER, iSkinParam);
            this.desc = TextBlockUtils.mergeTB(textBlock, bodyEnhanced, HorizontalAlignment.CENTER);
        }
        this.url = iLeaf.getUrl99();
    }

    private UStroke getStroke() {
        UStroke uStroke = this.getSkinParam().getThickness(LineParam.usecaseBorder, this.getStereo());
        if (uStroke == null) {
            uStroke = new UStroke(1.5);
        }
        return uStroke;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new TextBlockInEllipse(this.desc, stringBounder).calculateDimension(stringBounder);
    }

    public final void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        TextBlockInEllipse textBlockInEllipse = new TextBlockInEllipse(this.desc, stringBounder);
        if (this.getSkinParam().shadowing()) {
            textBlockInEllipse.setDeltaShadow(3.0);
        }
        if (this.url != null) {
            uGraphic.startUrl(this.url);
        }
        uGraphic = uGraphic.apply(this.getStroke());
        HtmlColor htmlColor = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.LINE);
        if (htmlColor == null) {
            htmlColor = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.usecaseBorder, this.getStereo());
        }
        uGraphic = uGraphic.apply(new UChangeColor(htmlColor));
        HtmlColor htmlColor2 = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.BACK);
        if (htmlColor2 == null) {
            htmlColor2 = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.usecaseBackground, this.getStereo());
        }
        uGraphic = uGraphic.apply(new UChangeBackColor(htmlColor2));
        MyUGraphicEllipse myUGraphicEllipse = new MyUGraphicEllipse(uGraphic, 0.0, 0.0, textBlockInEllipse.getUEllipse());
        textBlockInEllipse.drawU(myUGraphicEllipse);
        if (this.url != null) {
            uGraphic.closeAction();
        }
    }

    public ShapeType getShapeType() {
        return ShapeType.OVAL;
    }

    static class MyUGraphicEllipse
    extends AbstractUGraphicHorizontalLine {
        private final double startingX;
        private final double yTheoricalPosition;
        private final UEllipse ellipse;

        protected AbstractUGraphicHorizontalLine copy(UGraphic uGraphic) {
            return new MyUGraphicEllipse(uGraphic, this.startingX, this.yTheoricalPosition, this.ellipse);
        }

        MyUGraphicEllipse(UGraphic uGraphic, double d, double d2, UEllipse uEllipse) {
            super(uGraphic);
            this.startingX = d;
            this.ellipse = uEllipse;
            this.yTheoricalPosition = d2;
        }

        private double getNormalized(double d) {
            if (d < this.yTheoricalPosition) {
                throw new IllegalArgumentException();
            }
            if ((d -= this.yTheoricalPosition) > this.ellipse.getHeight()) {
                throw new IllegalArgumentException();
            }
            return d;
        }

        private double getStartingXInternal(double d) {
            return this.startingX + this.ellipse.getStartingX(this.getNormalized(d));
        }

        private double getEndingXInternal(double d) {
            return this.startingX + this.ellipse.getEndingX(this.getNormalized(d));
        }

        private Stencil getStencil2(UTranslate uTranslate) {
            final double d = uTranslate.getDy();
            return new Stencil(){

                public double getStartingX(StringBounder stringBounder, double d2) {
                    return MyUGraphicEllipse.this.getStartingXInternal(d2 + d);
                }

                public double getEndingX(StringBounder stringBounder, double d2) {
                    return MyUGraphicEllipse.this.getEndingXInternal(d2 + d);
                }
            };
        }

        protected void drawHline(UGraphic uGraphic, UHorizontalLine uHorizontalLine, UTranslate uTranslate) {
            UStroke uStroke = new UStroke(1.5);
            uHorizontalLine.drawLineInternal(uGraphic.apply(uTranslate), this.getStencil2(uTranslate), 0.0, uStroke);
        }
    }
}

