/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.timingdiagram;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorUtils;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeArrow;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeTick;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimingRuler;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class TimeConstraint {
    private final TimeTick tick1;
    private final TimeTick tick2;
    private final Display label;

    public TimeConstraint(TimeTick timeTick, TimeTick timeTick2, String string) {
        this.tick1 = timeTick;
        this.tick2 = timeTick2;
        this.label = Display.getWithNewlines(string);
    }

    public final TimeTick getTick1() {
        return this.tick1;
    }

    public final TimeTick getTick2() {
        return this.tick2;
    }

    public final Display getLabel() {
        return this.label;
    }

    private TextBlock getTextBlock(Display display, ISkinParam iSkinParam) {
        return display.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, iSkinParam);
    }

    private FontConfiguration getFontConfiguration() {
        UFont uFont = UFont.serif(14);
        return new FontConfiguration(uFont, HtmlColorUtils.BLACK, HtmlColorUtils.BLUE, false);
    }

    public void drawU(UGraphic uGraphic, TimingRuler timingRuler, ISkinParam iSkinParam) {
        uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.RED)).apply(new UChangeBackColor(HtmlColorUtils.RED));
        double d = timingRuler.getPosInPixel(this.tick1);
        double d2 = timingRuler.getPosInPixel(this.tick2);
        ULine uLine = new ULine(d2 - d, 0.0);
        uGraphic = uGraphic.apply(new UTranslate(d, 0.0));
        uGraphic.draw(uLine);
        uGraphic.draw(this.getPolygon(-1.5707963267948966, new Point2D.Double(0.0, 0.0)));
        uGraphic.draw(this.getPolygon(1.5707963267948966, new Point2D.Double(d2 - d, 0.0)));
        TextBlock textBlock = this.getTextBlock(this.label, iSkinParam);
        Dimension2D dimension2D = textBlock.calculateDimension(uGraphic.getStringBounder());
        double d3 = (d2 - d - dimension2D.getWidth()) / 2.0;
        UTranslate uTranslate = new UTranslate(d3, -5.0 - dimension2D.getHeight());
        textBlock.drawU(uGraphic.apply(uTranslate));
    }

    private UPolygon getPolygon(double d, Point2D point2D) {
        Point2D point2D2 = TimeArrow.onCircle(point2D, d + 0.3490658503988659);
        Point2D point2D3 = TimeArrow.onCircle(point2D, d - 0.3490658503988659);
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(point2D2.getX(), point2D2.getY());
        uPolygon.addPoint(point2D3.getX(), point2D3.getY());
        uPolygon.addPoint(point2D.getX(), point2D.getY());
        return uPolygon;
    }
}

