/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.timingdiagram;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.UmlDiagram;
import znaishaded.net.sourceforge.plantuml.UmlDiagramType;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorUtils;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.UDrawable;
import znaishaded.net.sourceforge.plantuml.timingdiagram.Clock;
import znaishaded.net.sourceforge.plantuml.timingdiagram.IntricatedPoint;
import znaishaded.net.sourceforge.plantuml.timingdiagram.Player;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TickInPlayer;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeArrow;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeMessage;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeTick;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimingRuler;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimingStyle;
import znaishaded.net.sourceforge.plantuml.ugraphic.ImageBuilder;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class TimingDiagram
extends UmlDiagram
implements Clock {
    private final Map<String, Player> players = new LinkedHashMap<String, Player>();
    private final List<TimeMessage> messages = new ArrayList<TimeMessage>();
    private final TimingRuler ruler = new TimingRuler(this.getSkinParam());
    private TimeTick now;
    private Player lastPlayer;
    public static final double marginX1 = 5.0;
    private final double marginX2 = 5.0;

    public DiagramDescription getDescription() {
        return new DiagramDescription("(Timing Diagram)");
    }

    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.TIMING;
    }

    protected ImageData exportDiagramInternal(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        ImageBuilder imageBuilder = new ImageBuilder(this.getSkinParam(), 1.0, fileFormatOption.isWithMetadata() ? this.getMetadata() : null, this.getWarningOrError(), 10.0, 10.0, this.getAnimation());
        imageBuilder.setUDrawable(this.getUDrawable());
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, this.seed(), outputStream);
    }

    private UDrawable getUDrawable() {
        return new UDrawable(){

            public void drawU(UGraphic uGraphic) {
                TimingDiagram.this.drawInternal(uGraphic);
            }
        };
    }

    private void drawInternal(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        UTranslate uTranslate = this.getUTranslateForPlayer(null, stringBounder);
        double d = this.getWithBeforeRuler(stringBounder);
        double d2 = d + this.ruler.getWidth() + 5.0 + 5.0;
        ULine uLine = new ULine(0.0, uTranslate.getDy());
        UStroke uStroke = new UStroke(1.7);
        uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK)).apply(uStroke).draw(uLine);
        uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK)).apply(uStroke).apply(new UTranslate(d2, 0.0)).draw(uLine);
        uGraphic = uGraphic.apply(new UTranslate(5.0, 0.0));
        for (Player object : this.players.values()) {
            UGraphic uGraphic2 = uGraphic.apply(this.getUTranslateForPlayer(object, stringBounder));
            object.drawU(uGraphic2);
            object.drawContent(uGraphic2.apply(new UTranslate(d, 0.0)));
            object.drawWidthHeader(uGraphic2);
            uGraphic2.apply(new UChangeColor(HtmlColorUtils.BLACK)).apply(uStroke).apply(new UTranslate(-5.0, 0.0)).draw(new ULine(d2, 0.0));
        }
        uGraphic = uGraphic.apply(new UTranslate(d, 0.0));
        this.ruler.draw(uGraphic.apply(uTranslate));
        for (TimeMessage timeMessage : this.messages) {
            this.drawMessages(uGraphic, timeMessage);
        }
    }

    private double getWithBeforeRuler(StringBounder stringBounder) {
        double d = 0.0;
        for (Player player : this.players.values()) {
            d = Math.max(d, player.getGetWidthHeader(stringBounder));
        }
        return d;
    }

    private void drawMessages(UGraphic uGraphic, TimeMessage timeMessage) {
        Player player = timeMessage.getPlayer1();
        Player player2 = timeMessage.getPlayer2();
        UTranslate uTranslate = this.getUTranslateForPlayer(player, uGraphic.getStringBounder());
        UTranslate uTranslate2 = this.getUTranslateForPlayer(player2, uGraphic.getStringBounder());
        IntricatedPoint intricatedPoint = player.getTimeProjection(uGraphic.getStringBounder(), timeMessage.getTick1());
        IntricatedPoint intricatedPoint2 = player2.getTimeProjection(uGraphic.getStringBounder(), timeMessage.getTick2());
        if (intricatedPoint == null || intricatedPoint2 == null) {
            return;
        }
        TimeArrow timeArrow = TimeArrow.create(intricatedPoint.translated(uTranslate), intricatedPoint2.translated(uTranslate2), timeMessage.getLabel(), this.getSkinParam());
        timeArrow.drawU(uGraphic);
    }

    public UTranslate getUTranslateForPlayer(Player player, StringBounder stringBounder) {
        double d = 0.0;
        for (Player player2 : this.players.values()) {
            Dimension2D dimension2D = player2.calculateDimension(stringBounder);
            if (player == player2) {
                return new UTranslate(0.0, d);
            }
            d += dimension2D.getHeight();
        }
        if (player == null) {
            return new UTranslate(0.0, d);
        }
        throw new IllegalArgumentException();
    }

    public void createLifeLine(String string, String string2, TimingStyle timingStyle) {
        Player player = new Player(string, string2, timingStyle, this.getSkinParam(), this.ruler);
        this.players.put(string, player);
        this.lastPlayer = player;
    }

    public void createTimeMessage(Player player, TimeTick timeTick, Player player2, TimeTick timeTick2, String string) {
        TimeMessage timeMessage = new TimeMessage(new TickInPlayer(player, timeTick), new TickInPlayer(player2, timeTick2), string);
        this.messages.add(timeMessage);
    }

    public void addTime(TimeTick timeTick) {
        this.now = timeTick;
        this.ruler.addTime(timeTick);
    }

    public void updateNow(TimeTick timeTick) {
        this.now = timeTick;
    }

    public Player getPlayer(String string) {
        return this.players.get(string);
    }

    public TimeTick getNow() {
        return this.now;
    }

    public void setLastPlayer(Player player) {
        this.lastPlayer = player;
    }

    public Player getLastPlayer() {
        return this.lastPlayer;
    }

    public void scaleInPixels(long l, long l2) {
        this.ruler.scaleInPixels(l, l2);
    }
}

