/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.BasicStroke;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.EnsureVisible;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorGradient;
import znaishaded.net.sourceforge.plantuml.ugraphic.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.UDriver;
import znaishaded.net.sourceforge.plantuml.ugraphic.UParam;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.UShape;
import znaishaded.net.sourceforge.plantuml.ugraphic.g2d.DriverLineG2d;
import znaishaded.net.sourceforge.plantuml.ugraphic.g2d.DriverRectangleG2d;
import znaishaded.net.sourceforge.plantuml.ugraphic.g2d.DriverShadowedG2d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverPolygonG2d
extends DriverShadowedG2d
implements UDriver<Graphics2D> {
    private final double dpiFactor;
    private final EnsureVisible visible;

    public DriverPolygonG2d(double d, EnsureVisible ensureVisible) {
        this.dpiFactor = d;
        this.visible = ensureVisible;
    }

    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, Graphics2D graphics2D) {
        Object object;
        UPolygon uPolygon = (UPolygon)uShape;
        graphics2D.setStroke(new BasicStroke((float)uParam.getStroke().getThickness()));
        GeneralPath generalPath = new GeneralPath();
        boolean bl = true;
        Object object2 = uPolygon.getPoints().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            double d3 = ((Point2D)object).getX() + d;
            double d4 = ((Point2D)object).getY() + d2;
            this.visible.ensureVisible(d3, d4);
            if (bl) {
                generalPath.moveTo((float)d3, (float)d4);
            } else {
                generalPath.lineTo((float)d3, (float)d4);
            }
            bl = false;
        }
        if (!bl) {
            generalPath.closePath();
        }
        if (uPolygon.getDeltaShadow() != 0.0) {
            this.drawShadow(graphics2D, generalPath, uPolygon.getDeltaShadow(), this.dpiFactor);
        }
        if ((object2 = uParam.getBackcolor()) instanceof HtmlColorGradient) {
            object = (HtmlColorGradient)object2;
            char c = ((HtmlColorGradient)object).getPolicy();
            GradientPaint gradientPaint = c == '|' ? new GradientPaint((float)d, (float)(d2 + uPolygon.getHeight()) / 2.0f, colorMapper.getMappedColor(((HtmlColorGradient)object).getColor1()), (float)(d + uPolygon.getWidth()), (float)(d2 + uPolygon.getHeight()) / 2.0f, colorMapper.getMappedColor(((HtmlColorGradient)object).getColor2())) : (c == '\\' ? new GradientPaint((float)d, (float)(d2 + uPolygon.getHeight()), colorMapper.getMappedColor(((HtmlColorGradient)object).getColor1()), (float)(d + uPolygon.getWidth()), (float)d2, colorMapper.getMappedColor(((HtmlColorGradient)object).getColor2())) : (c == '-' ? new GradientPaint((float)(d + uPolygon.getWidth()) / 2.0f, (float)d2, colorMapper.getMappedColor(((HtmlColorGradient)object).getColor1()), (float)(d + uPolygon.getWidth()) / 2.0f, (float)(d2 + uPolygon.getHeight()), colorMapper.getMappedColor(((HtmlColorGradient)object).getColor2())) : new GradientPaint((float)d, (float)d2, colorMapper.getMappedColor(((HtmlColorGradient)object).getColor1()), (float)(d + uPolygon.getWidth()), (float)(d2 + uPolygon.getHeight()), colorMapper.getMappedColor(((HtmlColorGradient)object).getColor2()))));
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(generalPath);
        } else if (object2 != null) {
            graphics2D.setColor(colorMapper.getMappedColor((HtmlColor)object2));
            DriverRectangleG2d.managePattern(uParam, graphics2D);
            graphics2D.fill(generalPath);
        }
        if (uParam.getColor() != null) {
            graphics2D.setColor(colorMapper.getMappedColor(uParam.getColor()));
            DriverLineG2d.manageStroke(uParam, graphics2D);
            graphics2D.draw(generalPath);
        }
    }
}

