/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.svg;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.TransformerException;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorGradient;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.posimo.DotPath;
import znaishaded.net.sourceforge.plantuml.svg.SvgGraphics;
import znaishaded.net.sourceforge.plantuml.ugraphic.AbstractCommonUGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.AbstractUGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ClipContainer;
import znaishaded.net.sourceforge.plantuml.ugraphic.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import znaishaded.net.sourceforge.plantuml.ugraphic.UComment;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic2;
import znaishaded.net.sourceforge.plantuml.ugraphic.UImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.UImageSvg;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPath;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UText;
import znaishaded.net.sourceforge.plantuml.ugraphic.svg.DriverCenteredCharacterSvg;
import znaishaded.net.sourceforge.plantuml.ugraphic.svg.DriverDotPathSvg;
import znaishaded.net.sourceforge.plantuml.ugraphic.svg.DriverEllipseSvg;
import znaishaded.net.sourceforge.plantuml.ugraphic.svg.DriverImagePng;
import znaishaded.net.sourceforge.plantuml.ugraphic.svg.DriverImageSvgSvg;
import znaishaded.net.sourceforge.plantuml.ugraphic.svg.DriverLineSvg;
import znaishaded.net.sourceforge.plantuml.ugraphic.svg.DriverPathSvg;
import znaishaded.net.sourceforge.plantuml.ugraphic.svg.DriverPolygonSvg;
import znaishaded.net.sourceforge.plantuml.ugraphic.svg.DriverRectangleSvg;
import znaishaded.net.sourceforge.plantuml.ugraphic.svg.DriverTextAsPathSvg;
import znaishaded.net.sourceforge.plantuml.ugraphic.svg.DriverTextSvg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UGraphicSvg
extends AbstractUGraphic<SvgGraphics>
implements ClipContainer,
UGraphic2 {
    private final StringBounder stringBounder;
    private final boolean textAsPath2;
    private final String target;

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        return new UGraphicSvg(this);
    }

    private UGraphicSvg(UGraphicSvg uGraphicSvg) {
        super(uGraphicSvg);
        this.stringBounder = uGraphicSvg.stringBounder;
        this.textAsPath2 = uGraphicSvg.textAsPath2;
        this.target = uGraphicSvg.target;
        this.register();
    }

    public UGraphicSvg(Dimension2D dimension2D, ColorMapper colorMapper, String string, boolean bl, double d, String string2, String string3, long l) {
        this(dimension2D, colorMapper, new SvgGraphics(dimension2D, string, d, string3, l), bl, string2);
    }

    public UGraphicSvg(Dimension2D dimension2D, ColorMapper colorMapper, boolean bl, double d, String string, String string2, long l) {
        this(dimension2D, colorMapper, new SvgGraphics(dimension2D, d, string2, l), bl, string);
    }

    public UGraphicSvg(Dimension2D dimension2D, ColorMapper colorMapper, HtmlColorGradient htmlColorGradient, boolean bl, double d, String string, String string2, long l) {
        this(dimension2D, colorMapper, new SvgGraphics(dimension2D, d, string2, l), bl, string);
        SvgGraphics svgGraphics = (SvgGraphics)this.getGraphicObject();
        svgGraphics.paintBackcolorGradient(colorMapper, htmlColorGradient);
    }

    @Override
    protected boolean manageHiddenAutomatically() {
        return false;
    }

    @Override
    protected void beforeDraw() {
        ((SvgGraphics)this.getGraphicObject()).setHidden(this.getParam().isHidden());
    }

    @Override
    protected void afterDraw() {
        ((SvgGraphics)this.getGraphicObject()).setHidden(false);
    }

    private UGraphicSvg(Dimension2D dimension2D, ColorMapper colorMapper, SvgGraphics svgGraphics, boolean bl, String string) {
        super(colorMapper, svgGraphics);
        this.stringBounder = FileFormat.PNG.getDefaultStringBounder();
        this.textAsPath2 = bl;
        this.target = string;
        this.register();
    }

    private void register() {
        this.registerDriver(URectangle.class, new DriverRectangleSvg(this));
        if (this.textAsPath2) {
            this.registerDriver(UText.class, new DriverTextAsPathSvg(TextBlockUtils.getFontRenderContext(), this));
        } else {
            this.registerDriver(UText.class, new DriverTextSvg(this.getStringBounder(), this));
        }
        this.registerDriver(ULine.class, new DriverLineSvg(this));
        this.registerDriver(UPolygon.class, new DriverPolygonSvg(this));
        this.registerDriver(UEllipse.class, new DriverEllipseSvg(this));
        this.registerDriver(UImage.class, new DriverImagePng(this));
        this.registerDriver(UImageSvg.class, new DriverImageSvgSvg());
        this.registerDriver(UPath.class, new DriverPathSvg(this));
        this.registerDriver(DotPath.class, new DriverDotPathSvg());
        this.registerDriver(UCenteredCharacter.class, new DriverCenteredCharacterSvg());
    }

    public SvgGraphics getSvgGraphics() {
        return (SvgGraphics)this.getGraphicObject();
    }

    @Override
    public StringBounder getStringBounder() {
        return this.stringBounder;
    }

    public void createXml(OutputStream outputStream, String string) throws IOException {
        try {
            if (string != null) {
                ((SvgGraphics)this.getGraphicObject()).addComment("\n" + string);
            }
            ((SvgGraphics)this.getGraphicObject()).createXml(outputStream);
        }
        catch (TransformerException transformerException) {
            throw new IOException(transformerException.toString());
        }
    }

    @Override
    public void startUrl(Url url) {
        ((SvgGraphics)this.getGraphicObject()).openLink(url.getUrl(), url.getTooltip(), this.target);
    }

    @Override
    public void closeAction() {
        ((SvgGraphics)this.getGraphicObject()).closeLink();
    }

    @Override
    public void writeImageTOBEMOVED(OutputStream outputStream, String string, int n) throws IOException {
        this.createXml(outputStream, string);
    }

    @Override
    protected void drawComment(UComment uComment) {
        ((SvgGraphics)this.getGraphicObject()).addComment(uComment.getComment());
    }

    @Override
    public boolean matchesProperty(String string) {
        if (string.equalsIgnoreCase("SVG")) {
            return true;
        }
        return super.matchesProperty(string);
    }
}

