/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.apache.tools.ant.types.selectors;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import znaishaded.org.apache.tools.ant.BuildException;
import znaishaded.org.apache.tools.ant.Project;
import znaishaded.org.apache.tools.ant.types.Parameter;
import znaishaded.org.apache.tools.ant.types.RegularExpression;
import znaishaded.org.apache.tools.ant.types.Resource;
import znaishaded.org.apache.tools.ant.types.resources.FileResource;
import znaishaded.org.apache.tools.ant.types.resources.selectors.ResourceSelector;
import znaishaded.org.apache.tools.ant.types.selectors.BaseExtendSelector;
import znaishaded.org.apache.tools.ant.util.regexp.Regexp;
import znaishaded.org.apache.tools.ant.util.regexp.RegexpUtil;

public class ContainsRegexpSelector
extends BaseExtendSelector
implements ResourceSelector {
    public static final String EXPRESSION_KEY = "expression";
    private static final String CS_KEY = "casesensitive";
    private static final String ML_KEY = "multiline";
    private static final String SL_KEY = "singleline";
    private String userProvidedExpression = null;
    private RegularExpression myRegExp = null;
    private Regexp myExpression = null;
    private boolean caseSensitive = true;
    private boolean multiLine = false;
    private boolean singleLine = false;

    @Override
    public String toString() {
        return String.format("{containsregexpselector expression: %s}", this.userProvidedExpression);
    }

    public void setExpression(String theexpression) {
        this.userProvidedExpression = theexpression;
    }

    public void setCaseSensitive(boolean b) {
        this.caseSensitive = b;
    }

    public void setMultiLine(boolean b) {
        this.multiLine = b;
    }

    public void setSingleLine(boolean b) {
        this.singleLine = b;
    }

    @Override
    public void setParameters(Parameter ... parameters) {
        super.setParameters(parameters);
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                String paramname = parameter.getName();
                if (EXPRESSION_KEY.equalsIgnoreCase(paramname)) {
                    this.setExpression(parameter.getValue());
                    continue;
                }
                if (CS_KEY.equalsIgnoreCase(paramname)) {
                    this.setCaseSensitive(Project.toBoolean(parameter.getValue()));
                    continue;
                }
                if (ML_KEY.equalsIgnoreCase(paramname)) {
                    this.setMultiLine(Project.toBoolean(parameter.getValue()));
                    continue;
                }
                if (SL_KEY.equalsIgnoreCase(paramname)) {
                    this.setSingleLine(Project.toBoolean(parameter.getValue()));
                    continue;
                }
                this.setError("Invalid parameter " + paramname);
            }
        }
    }

    @Override
    public void verifySettings() {
        if (this.userProvidedExpression == null) {
            this.setError("The expression attribute is required");
        }
    }

    @Override
    public boolean isSelected(File basedir, String filename, File file) {
        return this.isSelected(new FileResource(file));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isSelected(Resource r) {
        this.validate();
        if (r.isDirectory()) {
            return true;
        }
        if (this.myRegExp == null) {
            this.myRegExp = new RegularExpression();
            this.myRegExp.setPattern(this.userProvidedExpression);
            this.myExpression = this.myRegExp.getRegexp(this.getProject());
        }
        try {
            Throwable throwable = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(r.getInputStream()));){
                String teststr = in.readLine();
                while (teststr != null) {
                    if (this.myExpression.matches(teststr, RegexpUtil.asOptions(this.caseSensitive, this.multiLine, this.singleLine))) {
                        boolean bl = true;
                        return bl;
                    }
                    teststr = in.readLine();
                }
                boolean bl = false;
                return bl;
            }
            catch (IOException ioe) {
                try {
                    throw new BuildException("Could not read " + r.toLongString());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        catch (IOException e) {
            throw new BuildException("Could not get InputStream from " + r.toLongString(), e);
        }
    }
}

