/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.apache.tools.ant.util;

import znaishaded.org.apache.tools.ant.AntClassLoader;
import znaishaded.org.apache.tools.ant.BuildException;
import znaishaded.org.apache.tools.ant.Project;
import znaishaded.org.apache.tools.ant.ProjectComponent;
import znaishaded.org.apache.tools.ant.types.Path;
import znaishaded.org.apache.tools.ant.types.Reference;

public class ClasspathUtils {
    public static final String REUSE_LOADER_REF = "ant.reuse.loader";

    public static ClassLoader getClassLoaderForPath(Project p, Reference ref) {
        return ClasspathUtils.getClassLoaderForPath(p, ref, false);
    }

    public static ClassLoader getClassLoaderForPath(Project p, Reference ref, boolean reverseLoader) {
        String pathId = ref.getRefId();
        Object path2 = p.getReference(pathId);
        if (!(path2 instanceof Path)) {
            throw new BuildException("The specified classpathref %s does not reference a Path.", pathId);
        }
        String loaderId = "ant.loader." + pathId;
        return ClasspathUtils.getClassLoaderForPath(p, (Path)path2, loaderId, reverseLoader);
    }

    public static ClassLoader getClassLoaderForPath(Project p, Path path2, String loaderId) {
        return ClasspathUtils.getClassLoaderForPath(p, path2, loaderId, false);
    }

    public static ClassLoader getClassLoaderForPath(Project p, Path path2, String loaderId, boolean reverseLoader) {
        return ClasspathUtils.getClassLoaderForPath(p, path2, loaderId, reverseLoader, ClasspathUtils.isMagicPropertySet(p));
    }

    public static ClassLoader getClassLoaderForPath(Project p, Path path2, String loaderId, boolean reverseLoader, boolean reuseLoader) {
        ClassLoader cl = null;
        if (loaderId != null && reuseLoader) {
            Object reusedLoader = p.getReference(loaderId);
            if (reusedLoader != null && !(reusedLoader instanceof ClassLoader)) {
                throw new BuildException("The specified loader id %s does not reference a class loader", loaderId);
            }
            cl = (ClassLoader)reusedLoader;
        }
        if (cl == null) {
            cl = ClasspathUtils.getUniqueClassLoaderForPath(p, path2, reverseLoader);
            if (loaderId != null && reuseLoader) {
                p.addReference(loaderId, cl);
            }
        }
        return cl;
    }

    public static ClassLoader getUniqueClassLoaderForPath(Project p, Path path2, boolean reverseLoader) {
        AntClassLoader acl = p.createClassLoader(path2);
        if (reverseLoader) {
            acl.setParentFirst(false);
            acl.addJavaLibraries();
        }
        return acl;
    }

    public static Object newInstance(String className, ClassLoader userDefinedLoader) {
        return ClasspathUtils.newInstance(className, userDefinedLoader, Object.class);
    }

    public static <T> T newInstance(String className, ClassLoader userDefinedLoader, Class<T> expectedType) {
        try {
            Class<?> clazz = Class.forName(className, true, userDefinedLoader);
            Object o = clazz.newInstance();
            if (!expectedType.isInstance(o)) {
                throw new BuildException("Class of unexpected Type: %s expected : %s", className, expectedType);
            }
            return (T)o;
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("Class not found: " + className, e);
        }
        catch (InstantiationException e) {
            throw new BuildException("Could not instantiate " + className + ". Specified class should have a no argument constructor.", e);
        }
        catch (IllegalAccessException e) {
            throw new BuildException("Could not instantiate " + className + ". Specified class should have a public constructor.", e);
        }
        catch (LinkageError e) {
            throw new BuildException("Class " + className + " could not be loaded because of an invalid dependency.", e);
        }
    }

    public static Delegate getDelegate(ProjectComponent component) {
        return new Delegate(component);
    }

    private static boolean isMagicPropertySet(Project p) {
        return p.getProperty(REUSE_LOADER_REF) != null;
    }

    private ClasspathUtils() {
    }

    public static class Delegate {
        private final ProjectComponent component;
        private Path classpath;
        private String classpathId;
        private String className;
        private String loaderId;
        private boolean reverseLoader = false;

        Delegate(ProjectComponent component) {
            this.component = component;
        }

        public void setClasspath(Path classpath) {
            if (this.classpath == null) {
                this.classpath = classpath;
            } else {
                this.classpath.append(classpath);
            }
        }

        public Path createClasspath() {
            if (this.classpath == null) {
                this.classpath = new Path(this.component.getProject());
            }
            return this.classpath.createPath();
        }

        public void setClassname(String fcqn) {
            this.className = fcqn;
        }

        public void setClasspathref(Reference r) {
            this.classpathId = r.getRefId();
            this.createClasspath().setRefid(r);
        }

        public void setReverseLoader(boolean reverseLoader) {
            this.reverseLoader = reverseLoader;
        }

        public void setLoaderRef(Reference r) {
            this.loaderId = r.getRefId();
        }

        public ClassLoader getClassLoader() {
            return ClasspathUtils.getClassLoaderForPath(this.getContextProject(), this.classpath, this.getClassLoadId(), this.reverseLoader, this.loaderId != null || ClasspathUtils.isMagicPropertySet(this.getContextProject()));
        }

        private Project getContextProject() {
            return this.component.getProject();
        }

        public String getClassLoadId() {
            if (this.loaderId == null && this.classpathId != null) {
                return "ant.loader." + this.classpathId;
            }
            return this.loaderId;
        }

        public Object newInstance() {
            return ClasspathUtils.newInstance(this.className, this.getClassLoader());
        }

        public Path getClasspath() {
            return this.classpath;
        }

        public boolean isReverseLoader() {
            return this.reverseLoader;
        }
    }
}

