/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.cli;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import znaishaded.io.vertx.core.http.HttpServer;
import znaishaded.org.testingisdocumenting.znai.cli.DocScaffolding;
import znaishaded.org.testingisdocumenting.znai.cli.ZnaiCliConfig;
import znaishaded.org.testingisdocumenting.znai.cli.extension.CliCommandConfig;
import znaishaded.org.testingisdocumenting.znai.console.ConsoleOutputs;
import znaishaded.org.testingisdocumenting.znai.console.ansi.AnsiConsoleOutput;
import znaishaded.org.testingisdocumenting.znai.console.ansi.Color;
import znaishaded.org.testingisdocumenting.znai.html.reactjs.ReactJsBundle;
import znaishaded.org.testingisdocumenting.znai.server.DocumentationServer;
import znaishaded.org.testingisdocumenting.znai.server.preview.DocumentationPreview;
import znaishaded.org.testingisdocumenting.znai.utils.FileUtils;
import znaishaded.org.testingisdocumenting.znai.web.WebResource;
import znaishaded.org.testingisdocumenting.znai.website.ProgressReporter;
import znaishaded.org.testingisdocumenting.znai.website.WebSite;
import znaishaded.org.testingisdocumenting.znai.website.modifiedtime.ConstantPageModifiedTime;
import znaishaded.org.testingisdocumenting.znai.website.modifiedtime.FileBasedPageModifiedTime;
import znaishaded.org.testingisdocumenting.znai.website.modifiedtime.PageModifiedTimeStrategy;

public class ZnaiCliApp {
    private final ZnaiCliConfig config;
    private final Path deployPath;
    private WebSite webSite;
    private ReactJsBundle reactJsBundle;

    public ZnaiCliApp(ZnaiCliConfig cliConfig) {
        System.setProperty("java.awt.headless", "true");
        this.config = cliConfig;
        this.deployPath = this.config.getDeployRoot().resolve(this.getDocId());
    }

    public static void start(ZnaiCliConfig cliConfig) {
        ZnaiCliApp cliApp = new ZnaiCliApp(cliConfig);
        cliApp.start();
    }

    public static void main(String[] args) {
        ConsoleOutputs.add(new AnsiConsoleOutput());
        ZnaiCliApp.start(new ZnaiCliConfig(args));
    }

    private String getDocId() {
        if (this.config.isPreviewMode()) {
            return "preview";
        }
        return this.config.getDocId();
    }

    private void start() {
        this.config.print();
        if (this.config.isScaffoldMode()) {
            this.createNew();
            return;
        }
        this.announceMode(this.config.getModeAsString());
        this.reactJsBundle = new ReactJsBundle();
        if (!this.config.isServeMode()) {
            this.generateDocs();
        }
        if (this.config.isPreviewMode()) {
            this.preview();
        } else if (this.config.isServeMode()) {
            this.serve();
        } else if (this.config.isExportMode()) {
            this.export();
        } else if (this.config.isCustomCommand()) {
            this.config.getSpecifiedCustomCommand().handle(new CliCommandConfig(this.config.getDocId(), this.config.getSourceRoot(), this.config.getDeployRoot(), this.config.getActor()));
        }
    }

    private void preview() {
        DocumentationPreview preview = new DocumentationPreview(this.config.getDeployRoot());
        preview.start(this.webSite, this.config.getPort());
    }

    private void serve() {
        HttpServer server = new DocumentationServer(this.reactJsBundle, this.config.getDeployRoot()).create();
        server.listen(this.config.getPort());
    }

    private void export() {
        ProgressReporter.reportPhase("export documentation files");
        ZnaiCliApp.copyDir(this.config.getSourceRoot(), this.config.getExportRoot());
        String artifactsDirName = "_artifacts";
        Path artifactsRoot = this.config.getExportRoot().resolve(artifactsDirName);
        ProgressReporter.reportPhase("export files that are required but outside of documentation");
        this.webSite.getOutsideDocsRequestedResources().forEach((k, v) -> {
            Path dest = artifactsRoot.resolve((String)k);
            ZnaiCliApp.copyFile(v, dest);
        });
        ProgressReporter.reportPhase("patching lookup-paths");
        Path lookupPath = this.config.getExportRoot().resolve("lookup-paths");
        String lookupContent = FileUtils.fileTextContent(lookupPath);
        FileUtils.writeTextContent(lookupPath, artifactsDirName + "\n" + lookupContent);
    }

    private static void copyFile(Path source, Path target) {
        ConsoleOutputs.out(new Object[]{"copy ", Color.PURPLE, source, Color.YELLOW, " to ", Color.PURPLE, target});
        FileUtils.copyFile(source, target);
    }

    public static void copyDir(Path source, Path target) {
        try {
            Files.walk(source, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(f -> ZnaiCliApp.copyFile(f, target.resolve(source.relativize((Path)f))));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void generateDocs() {
        Path userDefinedFavicon = this.config.getSourceRoot().resolve("favicon.png");
        WebResource favIconResource = Files.exists(userDefinedFavicon, new LinkOption[0]) ? WebResource.withPath(userDefinedFavicon, "favicon.png") : WebResource.fromResource("favicon.png");
        WebSite.Configuration webSiteCfg = WebSite.withRoot(this.config.getSourceRoot()).withReactJsBundle(this.reactJsBundle).withId(this.getDocId()).withDocumentationType(this.config.getMarkupType()).withMetaFromJsonFile(this.config.getSourceRoot().resolve("meta.json")).withFileWithLookupPaths("lookup-paths").withFooterPath(this.config.getSourceRoot().resolve("footer.md")).withExtensionsDefPath(this.config.getSourceRoot().resolve("extensions.json")).withGlobalReferencesPath(this.config.getSourceRoot().resolve("references.csv")).withWebResources(favIconResource).withPageModifiedTimeStrategy(this.pageModifiedTimeStrategy()).withEnabledPreview(this.config.isPreviewMode());
        this.webSite = this.config.isExportMode() ? webSiteCfg.parseOnly() : webSiteCfg.deployTo(this.deployPath);
    }

    private PageModifiedTimeStrategy pageModifiedTimeStrategy() {
        switch (this.config.getModifiedTimeStrategy()) {
            case FILE: {
                return new FileBasedPageModifiedTime();
            }
            case CONSTANT: {
                return new ConstantPageModifiedTime(Instant.now());
            }
        }
        return null;
    }

    private void createNew() {
        Path pathToScaffold = (this.config.isSourceRootSet() ? this.config.getSourceRoot() : Paths.get("znai", new String[0])).toAbsolutePath();
        ConsoleOutputs.out(new Object[]{Color.BLUE, "scaffolding new documentation: ", Color.PURPLE, pathToScaffold});
        DocScaffolding scaffolding = new DocScaffolding(pathToScaffold);
        scaffolding.create();
    }

    private void announceMode(String name) {
        ConsoleOutputs.out(new Object[]{Color.BLUE, "znai ", Color.YELLOW, name + " mode"});
    }
}

