/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.core;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import znaishaded.org.testingisdocumenting.znai.core.AuxiliaryFile;
import znaishaded.org.testingisdocumenting.znai.core.AuxiliaryFileListener;
import znaishaded.org.testingisdocumenting.znai.structure.TocItem;

public class AuxiliaryFilesRegistry {
    private final Map<Path, Set<TocItem>> tocItemsByAuxiliaryFilePath = new HashMap<Path, Set<TocItem>>();
    private final Map<TocItem, Set<AuxiliaryFile>> auxiliaryFilesByTocItem = new HashMap<TocItem, Set<AuxiliaryFile>>();
    private final Map<Path, AuxiliaryFile> auxiliaryFiles = new HashMap<Path, AuxiliaryFile>();
    private final Set<AuxiliaryFileListener> auxiliaryFileListeners = new HashSet<AuxiliaryFileListener>();

    public Set<TocItem> tocItemsByPath(Path auxiliaryFile) {
        return this.tocItemsByAuxiliaryFilePath.getOrDefault(auxiliaryFile, Collections.emptySet());
    }

    public Set<AuxiliaryFile> auxiliaryFilesByTocItem(TocItem tocItem) {
        return this.auxiliaryFilesByTocItem.getOrDefault(tocItem, Collections.emptySet());
    }

    public void updateFileAssociations(TocItem tocItem, AuxiliaryFile auxiliaryFile) {
        Set tocItems = this.tocItemsByAuxiliaryFilePath.computeIfAbsent(auxiliaryFile.getPath(), k -> new HashSet());
        tocItems.add(tocItem);
        Set filesForTocItem = this.auxiliaryFilesByTocItem.computeIfAbsent(tocItem, k -> new HashSet());
        filesForTocItem.add(auxiliaryFile);
        if (!this.auxiliaryFiles.containsKey(auxiliaryFile.getPath()) || !this.auxiliaryFiles.get(auxiliaryFile.getPath()).isDeploymentRequired()) {
            this.auxiliaryFiles.put(auxiliaryFile.getPath(), auxiliaryFile);
        }
        this.auxiliaryFileListeners.forEach(listener -> listener.onAuxiliaryFile(auxiliaryFile));
    }

    public AuxiliaryFile auxiliaryFileByPath(Path path2) {
        return this.auxiliaryFiles.get(path2);
    }

    public Stream<AuxiliaryFile> getAuxiliaryFilesForDeployment() {
        return this.auxiliaryFiles.values().stream().filter(AuxiliaryFile::isDeploymentRequired);
    }

    public boolean requiresDeployment(Path path2) {
        AuxiliaryFile auxiliaryFile = this.auxiliaryFiles.get(path2);
        return auxiliaryFile != null && auxiliaryFile.isDeploymentRequired();
    }

    public Stream<Path> getAllPaths() {
        return this.auxiliaryFiles.keySet().stream();
    }

    public void registerListener(AuxiliaryFileListener listener) {
        this.auxiliaryFileListeners.add(listener);
    }

    public void unregisterListener(AuxiliaryFileListener listener) {
        this.auxiliaryFileListeners.remove(listener);
    }
}

