/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.core;

import java.awt.image.BufferedImage;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import znaishaded.org.testingisdocumenting.znai.core.ResourcesResolver;
import znaishaded.org.testingisdocumenting.znai.core.UnresolvedResourceException;
import znaishaded.org.testingisdocumenting.znai.utils.ServiceLoaderUtils;

public class ResourcesResolverChain
implements ResourcesResolver {
    private List<ResourcesResolver> resolvers = new ArrayList<ResourcesResolver>(ServiceLoaderUtils.load(ResourcesResolver.class));

    public void addResolver(ResourcesResolver resourcesResolver) {
        this.resolvers.add(resourcesResolver);
    }

    @Override
    public void initialize(Stream<String> filteredLookupPaths) {
        List lookupPaths = filteredLookupPaths.collect(Collectors.toList());
        this.resolvers.forEach(r -> this.initializeWithFilteredPaths((ResourcesResolver)r, lookupPaths.stream()));
    }

    @Override
    public boolean supportsLookupPath(String lookupPath) {
        return true;
    }

    @Override
    public boolean canResolve(String path2) {
        return this.resolvers.stream().map(r -> r.canResolve(path2)).filter(can -> can).findFirst().orElse(false);
    }

    @Override
    public List<String> listOfTriedLocations(String path2) {
        return this.resolvers.stream().flatMap(r -> r.listOfTriedLocations(path2).stream()).collect(Collectors.toList());
    }

    @Override
    public String textContent(String path2) {
        return this.resolver(path2).textContent(path2);
    }

    @Override
    public BufferedImage imageContent(String path2) {
        return this.resolver(path2).imageContent(path2);
    }

    @Override
    public Path fullPath(String path2) {
        return this.resolver(path2).fullPath(path2);
    }

    @Override
    public Path docRootRelativePath(Path path2) {
        return this.resolver(path2.toString()).docRootRelativePath(path2);
    }

    @Override
    public boolean isInsideDoc(Path path2) {
        return this.resolver(path2.toString()).isInsideDoc(path2);
    }

    @Override
    public boolean isLocalFile(String path2) {
        return this.resolver(path2).isLocalFile(path2);
    }

    private void initializeWithFilteredPaths(ResourcesResolver r, Stream<String> filteredLookupPaths) {
        r.initialize(filteredLookupPaths.filter(r::supportsLookupPath).collect(Collectors.toList()).stream());
    }

    private ResourcesResolver resolver(String path2) {
        return this.resolvers.stream().filter(r -> r.canResolve(path2)).findFirst().orElseThrow(() -> new UnresolvedResourceException(this.resolvers.stream(), path2));
    }
}

