/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.cpp;

import java.util.List;
import java.util.stream.Collectors;
import znaishaded.org.testingisdocumenting.znai.cpp.parser.EntryDef;
import znaishaded.org.testingisdocumenting.znai.utils.StringUtils;

public class ClassDefBuilder {
    private String name;
    private int startLine;
    private int endLine;
    private StringBuilder bodyOnly;
    private int nonClosedScopes;
    private List<String> codeLines;

    public ClassDefBuilder(List<String> codeLines) {
        this.codeLines = codeLines;
        this.bodyOnly = new StringBuilder();
    }

    public void addToBody(String text) {
        this.bodyOnly.append(text);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setStartLine(int startLine) {
        this.startLine = startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    public EntryDef build() {
        return new EntryDef(this.name, this.codeLines.subList(this.startLine - 1, this.endLine).stream().collect(Collectors.joining("\n")), this.stripIndentation());
    }

    private String stripIndentation() {
        return StringUtils.stripIndentation(this.bodyOnly.substring(1, this.bodyOnly.length() - 1));
    }

    public String toString() {
        return "name='" + this.name + '\'' + ", startLine=" + this.startLine + ", endLine=" + this.endLine + ", bodyOnly=" + this.bodyOnly;
    }

    public void scopeOpen() {
        ++this.nonClosedScopes;
    }

    public void scopeClose() {
        --this.nonClosedScopes;
    }

    public boolean isMainScopeClosed() {
        return this.nonClosedScopes == 0;
    }
}

