/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.cpp.extensions;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import znaishaded.org.testingisdocumenting.znai.codesnippets.CodeSnippetsProps;
import znaishaded.org.testingisdocumenting.znai.core.AuxiliaryFile;
import znaishaded.org.testingisdocumenting.znai.core.ComponentsRegistry;
import znaishaded.org.testingisdocumenting.znai.cpp.parser.CodePart;
import znaishaded.org.testingisdocumenting.znai.cpp.parser.CppSourceCode;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginParams;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginParamsOpts;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginResult;
import znaishaded.org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import znaishaded.org.testingisdocumenting.znai.parser.MarkupParser;
import znaishaded.org.testingisdocumenting.znai.parser.MarkupParserResult;
import znaishaded.org.testingisdocumenting.znai.parser.ParserHandler;
import znaishaded.org.testingisdocumenting.znai.parser.docelement.DocElement;

public class CppIncludePlugin
implements IncludePlugin {
    private MarkupParser markupParser;
    private Path cppPath;
    private String fileName;

    @Override
    public String id() {
        return "cpp";
    }

    @Override
    public IncludePlugin create() {
        return new CppIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.markupParser = componentsRegistry.defaultParser();
        this.fileName = pluginParams.getFreeParam();
        this.cppPath = componentsRegistry.resourceResolver().fullPath(this.fileName);
        PluginParamsOpts opts = pluginParams.getOpts();
        String commentsType = opts.has("comments") ? (String)opts.get("comments") : "";
        String text = componentsRegistry.resourceResolver().textContent(this.fileName);
        String snippet = this.extractSnippet(text, opts);
        List<CodePart> codeParts = commentsType.equals("inline") ? CppSourceCode.splitOnComments(snippet) : Collections.singletonList(new CodePart(false, snippet));
        return PluginResult.docElements(codeParts.stream().flatMap(this::convertToDocElement));
    }

    private Stream<DocElement> convertToDocElement(CodePart codePart) {
        return codePart.isComment() ? this.parseComments(codePart.getData()) : this.createSnippet(codePart.getData());
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(AuxiliaryFile.builtTime(this.cppPath));
    }

    private Stream<DocElement> parseComments(String data) {
        MarkupParserResult parserResult = this.markupParser.parse(this.cppPath, data);
        return parserResult.getDocElement().getContent().stream();
    }

    private Stream<DocElement> createSnippet(String snippet) {
        DocElement docElement = new DocElement("Snippet");
        Map<String, Object> props = CodeSnippetsProps.create("cpp", snippet);
        props.forEach(docElement::addProp);
        return Stream.of(docElement);
    }

    private String extractSnippet(String text, PluginParamsOpts opts) {
        String entry = (String)opts.get("entry");
        if (entry == null) {
            return text;
        }
        Boolean bodyOnly = (Boolean)opts.get("bodyOnly");
        return bodyOnly != null && bodyOnly != false ? CppSourceCode.entryBodyOnly(text, entry) : CppSourceCode.entryDefinition(text, entry);
    }
}

