/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.cpp.parser;

import java.util.ArrayList;
import java.util.List;
import znaishaded.org.antlr.v4.runtime.Token;
import znaishaded.org.antlr.v4.runtime.TokenStream;
import znaishaded.org.testingisdocumenting.znai.cpp.parser.CPP14Parser;
import znaishaded.org.testingisdocumenting.znai.cpp.parser.CodePart;

public class SplitOnCommentsTokensProcessor {
    private CPP14Parser parser;
    private List<CodePart> parts;
    private String currentSpaces = "";

    public SplitOnCommentsTokensProcessor(CPP14Parser parser) {
        this.parser = parser;
        this.parts = new ArrayList<CodePart>();
    }

    public List<CodePart> extractParts() {
        TokenStream stream = this.parser.getTokenStream();
        for (int i = 0; i < stream.size(); ++i) {
            Token token = stream.get(i);
            this.processToken(token);
        }
        return this.parts;
    }

    private void processToken(Token token) {
        CodePart last;
        if (token.getType() == -1) {
            return;
        }
        CodePart codePart = last = this.parts.isEmpty() ? null : this.parts.get(this.parts.size() - 1);
        if (this.isWhiteSpace(token)) {
            this.currentSpaces = this.currentSpaces + token.getText();
        } else if (last != null && this.isCompatibleType(last, token)) {
            last.add(this.extractText(token));
        } else {
            this.parts.add(new CodePart(this.isComment(token), this.extractText(token)));
        }
    }

    private String extractText(Token token) {
        String result = this.currentSpaces + token.getText();
        this.currentSpaces = "";
        return result;
    }

    private boolean isCompatibleType(CodePart last, Token token) {
        return this.isNewLine(token) || last.isComment() && this.isComment(token) || !last.isComment() && !this.isComment(token);
    }

    private boolean isComment(Token token) {
        return token.getType() == 141 || token.getType() == 142;
    }

    private boolean isNewLine(Token token) {
        return token.getType() == 140;
    }

    private boolean isWhiteSpace(Token token) {
        return token.getType() == 139;
    }
}

