/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.diagrams;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import znaishaded.org.testingisdocumenting.znai.core.ComponentsRegistry;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginParams;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginParamsOpts;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginResult;
import znaishaded.org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import znaishaded.org.testingisdocumenting.znai.parser.ParserHandler;
import znaishaded.org.testingisdocumenting.znai.search.SearchScore;
import znaishaded.org.testingisdocumenting.znai.search.SearchText;

public class DiagramLegendIncludePlugin
implements IncludePlugin {
    private static final String CLICKABLE_NODES_NAME = "clickableNodes";
    private Map<String, String> legend;

    @Override
    public String id() {
        return "diagram-legend";
    }

    @Override
    public IncludePlugin create() {
        return new DiagramLegendIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        Boolean clickableNodes = pluginParams.getOpts().get(CLICKABLE_NODES_NAME, false);
        this.legend = this.extractLegend(pluginParams.getOpts());
        this.legend.remove(CLICKABLE_NODES_NAME);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("legend", this.legend);
        props.put(CLICKABLE_NODES_NAME, clickableNodes);
        return PluginResult.docElement("DiagramLegend", props);
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.STANDARD.text(String.join((CharSequence)" ", this.legend.values()));
    }

    private Map<String, String> extractLegend(PluginParamsOpts opts) {
        HashMap<String, String> result = new HashMap<String, String>();
        opts.forEach((k, v) -> result.put((String)k, v.toString()));
        result.remove(CLICKABLE_NODES_NAME);
        return result;
    }
}

