/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.diagrams;

import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import znaishaded.org.testingisdocumenting.znai.core.AuxiliaryFile;
import znaishaded.org.testingisdocumenting.znai.core.ComponentsRegistry;
import znaishaded.org.testingisdocumenting.znai.core.ResourcesResolver;
import znaishaded.org.testingisdocumenting.znai.diagrams.DiagramsGlobalAssetsRegistration;
import znaishaded.org.testingisdocumenting.znai.diagrams.graphviz.Graphviz;
import znaishaded.org.testingisdocumenting.znai.diagrams.graphviz.GraphvizDiagram;
import znaishaded.org.testingisdocumenting.znai.diagrams.graphviz.gen.DiagramNode;
import znaishaded.org.testingisdocumenting.znai.diagrams.graphviz.gen.GraphvizFromJsonGen;
import znaishaded.org.testingisdocumenting.znai.diagrams.graphviz.gen.GraphvizGenConfig;
import znaishaded.org.testingisdocumenting.znai.diagrams.graphviz.gen.GraphvizGenResult;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginParams;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginResult;
import znaishaded.org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import znaishaded.org.testingisdocumenting.znai.parser.ParserHandler;
import znaishaded.org.testingisdocumenting.znai.structure.DocStructure;
import znaishaded.org.testingisdocumenting.znai.structure.DocUrl;
import znaishaded.org.testingisdocumenting.znai.utils.JsonUtils;

public class FlowChartIncludePlugin
implements IncludePlugin {
    private static final AtomicInteger diagramCount = new AtomicInteger();
    private Path filePath;
    private List<Path> nodeLibPath;
    private DocStructure docStructure;
    private Path markupPath;

    @Override
    public String id() {
        return "flow-chart";
    }

    @Override
    public IncludePlugin create() {
        return new FlowChartIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.markupPath = markupPath;
        this.filePath = componentsRegistry.resourceResolver().fullPath(pluginParams.getFreeParam());
        this.docStructure = componentsRegistry.docStructure();
        DiagramsGlobalAssetsRegistration.register(componentsRegistry.globalAssetsRegistry());
        String graphJson = componentsRegistry.resourceResolver().textContent(this.filePath);
        GraphvizGenConfig genConfig = new GraphvizGenConfig();
        genConfig.setVertical(pluginParams.getOpts().get("vertical", false));
        Map<String, ?> graph = JsonUtils.deserializeAsMap(graphJson);
        GraphvizGenResult genResult = new GraphvizFromJsonGen(graph, this.loadNodeLibraries(componentsRegistry.resourceResolver(), pluginParams), genConfig).generate();
        GraphvizDiagram diagram = Graphviz.graphvizEngine.diagramFromGv(pluginParams.getOpts().get("layout", "dot"), "dag" + diagramCount.incrementAndGet(), genResult.getGraphViz());
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("diagram", diagram.toMap());
        props.put("idsToHighlight", pluginParams.getOpts().getList("highlight"));
        props.put("wide", pluginParams.getOpts().get("wide", false));
        Map<String, String> urls = this.extractUrls(genResult.getUsedNodes());
        this.validateUrls(markupPath, urls);
        props.put("urls", this.convertUrls(urls));
        return PluginResult.docElement("GraphVizDiagram", props);
    }

    private Map<String, String> extractUrls(Collection<DiagramNode> nodes) {
        return nodes.stream().filter(DiagramNode::hasUrl).collect(Collectors.toMap(DiagramNode::getId, DiagramNode::getUrl));
    }

    private void validateUrls(Path markupPath, Map<String, String> urls) {
        urls.values().forEach(url -> this.docStructure.validateUrl(markupPath, "inside :include-flow-chart:", new DocUrl((String)url)));
    }

    private Map<String, String> convertUrls(Map<String, String> urls) {
        return urls.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, this::buildUrl));
    }

    private List<List<?>> loadNodeLibraries(ResourcesResolver resourcesResolver, PluginParams pluginParams) {
        this.nodeLibPath = pluginParams.getOpts().getList("nodeLibPath").stream().map(filePath -> resourcesResolver.fullPath(filePath.toString())).collect(Collectors.toList());
        return this.nodeLibPath.stream().map(resourcesResolver::textContent).map(JsonUtils::deserializeAsList).collect(Collectors.toList());
    }

    private String buildUrl(Map.Entry<String, String> entry) {
        return this.docStructure.createUrl(this.markupPath, new DocUrl(entry.getValue()));
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.concat(Stream.of(AuxiliaryFile.builtTime(this.filePath)), this.nodeLibPath.stream().map(AuxiliaryFile::builtTime));
    }
}

