/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.extensions;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginParamsOpts;
import znaishaded.org.testingisdocumenting.znai.utils.JsonUtils;

public class PluginParams {
    private static final String RIGHT_SIDE_OPT_NAME = "rightSide";
    private String pluginId;
    private String freeParam;
    private PluginParamsOpts opts;
    public static final PluginParams EMPTY = new PluginParams("");

    public PluginParams(String pluginId) {
        this.pluginId = pluginId;
        this.opts = new PluginParamsOpts(Collections.emptyMap());
    }

    public PluginParams(String pluginId, String value) {
        this.pluginId = pluginId;
        this.setValue(value);
    }

    public PluginParams(String pluginId, Map<String, ?> opts) {
        this.pluginId = pluginId;
        this.opts = new PluginParamsOpts(this.shortcutRightSideOption(opts));
    }

    public void setValue(String value) {
        this.freeParam = this.extractFreeParam(value);
        this.opts = new PluginParamsOpts(this.shortcutRightSideOption(this.extractMap(value)));
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getFreeParam() {
        return this.freeParam;
    }

    public PluginParamsOpts getOpts() {
        return this.opts;
    }

    private String extractFreeParam(String value) {
        int optsStartIdx = value.indexOf(123);
        return (optsStartIdx != -1 ? value.substring(0, optsStartIdx) : value).trim();
    }

    private Map<String, ?> extractMap(String value) {
        int optsStartIdx = value.indexOf(123);
        if (optsStartIdx == -1) {
            return Collections.emptyMap();
        }
        String json = value.substring(optsStartIdx);
        return JsonUtils.deserializeAsMap(json);
    }

    private Map<String, ?> shortcutRightSideOption(Map<String, ?> opts) {
        LinkedHashMap result = new LinkedHashMap(opts);
        Object rightSide = opts.get(RIGHT_SIDE_OPT_NAME);
        if (rightSide == null) {
            return result;
        }
        if (!this.pluginId.equals("meta")) {
            result.put("meta", Collections.singletonMap(RIGHT_SIDE_OPT_NAME, rightSide));
            result.remove(RIGHT_SIDE_OPT_NAME);
        }
        return result;
    }
}

