/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.extensions.api;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import znaishaded.org.testingisdocumenting.znai.extensions.api.ApiParameter;
import znaishaded.org.testingisdocumenting.znai.extensions.api.ApiParameters;
import znaishaded.org.testingisdocumenting.znai.parser.MarkupParser;
import znaishaded.org.testingisdocumenting.znai.parser.MarkupParserResult;
import znaishaded.org.testingisdocumenting.znai.parser.table.CsvParser;
import znaishaded.org.testingisdocumenting.znai.parser.table.MarkupTableData;
import znaishaded.org.testingisdocumenting.znai.parser.table.Row;

public class ApiParametersCsvParser {
    private final ApiParameters apiParameters;
    private final MarkupParser markupParser;
    private final String csvContent;
    private final Path path;

    public static ApiParameters parse(MarkupParser markupParser, String csvContent) {
        return new ApiParametersCsvParser(markupParser, csvContent).parse();
    }

    private ApiParametersCsvParser(MarkupParser markupParser, String csvContent) {
        this.markupParser = markupParser;
        this.csvContent = csvContent;
        this.apiParameters = new ApiParameters();
        this.path = Paths.get("", new String[0]);
    }

    public ApiParameters parse() {
        MarkupTableData tableData = CsvParser.parseWithHeader(this.csvContent, "name", "type", "description");
        tableData.forEachRow(this::parseRow);
        return this.apiParameters;
    }

    private void parseRow(Row row) {
        boolean escapedName;
        String name = (String)row.get(0);
        String type = (String)row.get(1);
        MarkupParserResult markupParserResult = this.markupParser.parse(this.path, (String)row.get(2));
        List<Map<String, Object>> description = markupParserResult.getDocElement().contentToListOfMaps();
        boolean bl = escapedName = name.startsWith("'") && name.endsWith("'");
        if (name.contains(".") && !name.contains("..") && !escapedName) {
            this.addNested(name, type, description);
        } else {
            name = escapedName ? name.substring(1, name.length() - 1) : name;
            this.apiParameters.add(name, type, description);
        }
    }

    private void addNested(String name, String type, List<Map<String, Object>> description) {
        String[] parts = name.split("\\.");
        ApiParameter apiParameter = this.apiParameters.find(parts[0]);
        for (int i = 1; i < parts.length - 1; ++i) {
            apiParameter = apiParameter.find(parts[i]);
        }
        apiParameter.add(parts[parts.length - 1], type, description);
    }
}

