/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.extensions.charts;

import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import znaishaded.org.testingisdocumenting.znai.core.AuxiliaryFile;
import znaishaded.org.testingisdocumenting.znai.core.ComponentsRegistry;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginParams;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginResult;
import znaishaded.org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import znaishaded.org.testingisdocumenting.znai.parser.ParserHandler;
import znaishaded.org.testingisdocumenting.znai.parser.table.CsvParser;

public class ChartIncludePlugin
implements IncludePlugin {
    private Path fullPath;

    @Override
    public String id() {
        return "chart";
    }

    @Override
    public IncludePlugin create() {
        return new ChartIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.fullPath = componentsRegistry.resourceResolver().fullPath(pluginParams.getFreeParam());
        String textContent = componentsRegistry.resourceResolver().textContent(this.fullPath);
        Map<String, Object> table = CsvParser.parse(textContent).toMap();
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(pluginParams.getOpts().toMap());
        props.put("chartType", props.get("type"));
        props.put("data", table.get("data"));
        return PluginResult.docElement("Chart", props);
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(AuxiliaryFile.builtTime(this.fullPath));
    }
}

