/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.extensions.cli;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;
import znaishaded.org.testingisdocumenting.znai.console.ConsoleOutputs;
import znaishaded.org.testingisdocumenting.znai.console.ansi.Color;
import znaishaded.org.testingisdocumenting.znai.core.AuxiliaryFile;
import znaishaded.org.testingisdocumenting.znai.core.ComponentsRegistry;
import znaishaded.org.testingisdocumenting.znai.core.ResourcesResolver;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginParams;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginParamsOpts;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginResult;
import znaishaded.org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import znaishaded.org.testingisdocumenting.znai.parser.ParserHandler;
import znaishaded.org.testingisdocumenting.znai.search.SearchScore;
import znaishaded.org.testingisdocumenting.znai.search.SearchText;

public class CliCommandIncludePlugin
implements IncludePlugin {
    private String command;
    private ResourcesResolver resourcesResolver;
    private String commandFile;

    @Override
    public String id() {
        return "cli-command";
    }

    @Override
    public IncludePlugin create() {
        return new CliCommandIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        Set<String> splitAfter;
        PluginParamsOpts opts = pluginParams.getOpts();
        LinkedHashSet<String> combinedParams = new LinkedHashSet<String>(opts.getList("paramToHighlight"));
        if (opts.has("paramToHighlight")) {
            ConsoleOutputs.out(new Object[]{Color.RED, "cli-command paramToHighlight will be deprecated"});
        }
        combinedParams.addAll(opts.getList("paramsToHighlight"));
        this.resourcesResolver = componentsRegistry.resourceResolver();
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        this.command = this.extractCommand(pluginParams);
        props.put("command", this.command);
        props.put("paramsToHighlight", combinedParams);
        this.validateParamsToHighlight(this.command, combinedParams);
        if (opts.has("threshold")) {
            props.put("threshold", opts.get("threshold"));
        }
        if (opts.has("presentationThreshold")) {
            props.put("presentationThreshold", opts.get("presentationThreshold"));
        }
        if (!(splitAfter = opts.getSet("splitAfter")).isEmpty()) {
            props.put("splitAfter", splitAfter);
            this.validateSplitAfter(this.command, splitAfter);
        }
        return PluginResult.docElement("CliCommand", props);
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return this.commandFile != null && !this.commandFile.isEmpty() ? Stream.of(AuxiliaryFile.builtTime(this.resourcesResolver.fullPath(this.commandFile))) : Stream.empty();
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.HIGH.text(this.command);
    }

    private void validateSplitAfter(String command, Set<String> splitAfter) {
        HashSet<String> commandParts = new HashSet<String>(Arrays.asList(command.split(" ")));
        for (String token : splitAfter) {
            if (commandParts.contains(token)) continue;
            throw new RuntimeException("split part \"" + token + "\" is not present in command: " + command);
        }
    }

    private void validateParamsToHighlight(String command, Set<String> paramsToHighlight) {
        for (String paramToHighlight : paramsToHighlight) {
            if (command.contains(paramToHighlight)) continue;
            throw new RuntimeException("param to highlight \"" + paramToHighlight + "\" is not present in command: " + command);
        }
    }

    private String extractCommand(PluginParams pluginParams) {
        String commandAsFreeParam = pluginParams.getFreeParam().trim();
        if (!commandAsFreeParam.isEmpty()) {
            return commandAsFreeParam;
        }
        PluginParamsOpts opts = pluginParams.getOpts();
        this.commandFile = opts.get("commandFile", "");
        if (!this.commandFile.isEmpty()) {
            return this.resourcesResolver.textContent(this.commandFile);
        }
        return opts.getRequiredString("command");
    }
}

