/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.extensions.file;

import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Stream;
import znaishaded.org.testingisdocumenting.znai.core.AuxiliaryFile;
import znaishaded.org.testingisdocumenting.znai.core.ComponentsRegistry;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginParams;
import znaishaded.org.testingisdocumenting.znai.extensions.features.PluginFeature;
import znaishaded.org.testingisdocumenting.znai.reference.DocReferences;
import znaishaded.org.testingisdocumenting.znai.reference.DocReferencesParser;
import znaishaded.org.testingisdocumenting.znai.structure.DocStructure;
import znaishaded.org.testingisdocumenting.znai.structure.DocUrl;

public class CodeReferencesFeature
implements PluginFeature {
    private final ComponentsRegistry componentsRegistry;
    private final Path referencesFullPath;
    private final String referencesPath;
    private final Path markupPath;
    private final DocReferences references;

    public CodeReferencesFeature(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams) {
        this.componentsRegistry = componentsRegistry;
        this.markupPath = markupPath;
        this.referencesPath = pluginParams.getOpts().get("referencesPath", null);
        this.referencesFullPath = this.referencesPath != null ? componentsRegistry.resourceResolver().fullPath(this.referencesPath) : null;
        this.references = this.buildReferences();
    }

    public DocReferences getReferences() {
        return this.references;
    }

    @Override
    public void updateProps(Map<String, Object> props) {
        if (!this.referencesProvided()) {
            return;
        }
        this.validateLinks(this.references);
        props.put("references", this.references.toMap());
    }

    private void validateLinks(DocReferences references) {
        DocStructure docStructure = this.componentsRegistry.docStructure();
        references.pageUrlsStream().forEach(pageUrl -> docStructure.validateUrl(this.markupPath, "reference file name: " + this.referencesFullPath.getFileName().toString(), new DocUrl((String)pageUrl)));
    }

    private DocReferences buildReferences() {
        if (this.referencesPath == null) {
            return DocReferences.EMPTY;
        }
        return DocReferencesParser.parse(this.componentsRegistry.resourceResolver().textContent(this.referencesPath));
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles() {
        return this.referencesProvided() ? Stream.of(AuxiliaryFile.builtTime(this.referencesFullPath)) : Stream.empty();
    }

    private boolean referencesProvided() {
        return this.referencesFullPath != null;
    }
}

