/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.extensions.file;

import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Stream;
import znaishaded.org.testingisdocumenting.znai.codesnippets.CodeSnippetsProps;
import znaishaded.org.testingisdocumenting.znai.core.AuxiliaryFile;
import znaishaded.org.testingisdocumenting.znai.core.ComponentsRegistry;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginParams;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginResult;
import znaishaded.org.testingisdocumenting.znai.extensions.features.PluginFeatureList;
import znaishaded.org.testingisdocumenting.znai.extensions.file.CodeReferencesFeature;
import znaishaded.org.testingisdocumenting.znai.extensions.file.FilePlugin;
import znaishaded.org.testingisdocumenting.znai.extensions.file.SnippetContentProvider;
import znaishaded.org.testingisdocumenting.znai.extensions.file.SnippetHighlightFeature;
import znaishaded.org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import znaishaded.org.testingisdocumenting.znai.parser.ParserHandler;
import znaishaded.org.testingisdocumenting.znai.search.SearchScore;
import znaishaded.org.testingisdocumenting.znai.search.SearchText;

public class FileIncludePlugin
implements IncludePlugin,
SnippetContentProvider {
    private String fileName;
    private String text;
    private PluginFeatureList features;

    @Override
    public String id() {
        return "file";
    }

    @Override
    public IncludePlugin create() {
        return new FileIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.features = new PluginFeatureList(new SnippetHighlightFeature(componentsRegistry, pluginParams, this), new CodeReferencesFeature(componentsRegistry, markupPath, pluginParams));
        this.fileName = pluginParams.getFreeParam();
        this.text = FilePlugin.extractText(componentsRegistry.resourceResolver().textContent(this.fileName), pluginParams.getOpts());
        String providedLang = pluginParams.getOpts().getString("lang");
        String langToUse = providedLang == null ? FileIncludePlugin.langFromFileName(this.fileName) : providedLang;
        Map<String, Object> props = CodeSnippetsProps.create(langToUse, this.text);
        props.putAll(pluginParams.getOpts().toMap());
        this.features.updateProps(props);
        return PluginResult.docElement("Snippet", props);
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return this.features.combineAuxiliaryFilesWith(Stream.of(AuxiliaryFile.builtTime(componentsRegistry.resourceResolver().fullPath(this.fileName))));
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.STANDARD.text(this.text);
    }

    private static String langFromFileName(String fileName) {
        String ext;
        switch (ext = FileIncludePlugin.extFromFileName(fileName)) {
            case "js": {
                return "javascript";
            }
        }
        return ext;
    }

    private static String extFromFileName(String fileName) {
        int dotLastIdx = fileName.lastIndexOf(46);
        if (dotLastIdx == -1) {
            return "";
        }
        return fileName.substring(dotLastIdx + 1);
    }

    @Override
    public String snippetContent() {
        return this.text;
    }

    @Override
    public String snippetId() {
        return this.fileName;
    }
}

