/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.extensions.file;

import java.nio.file.Path;
import java.util.Collections;
import java.util.stream.Stream;
import znaishaded.org.testingisdocumenting.znai.core.AuxiliaryFile;
import znaishaded.org.testingisdocumenting.znai.core.ComponentsRegistry;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginParams;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginResult;
import znaishaded.org.testingisdocumenting.znai.extensions.file.FilePlugin;
import znaishaded.org.testingisdocumenting.znai.extensions.inlinedcode.InlinedCodePlugin;
import znaishaded.org.testingisdocumenting.znai.search.SearchScore;
import znaishaded.org.testingisdocumenting.znai.search.SearchText;

public class FileInlinedCodePlugin
implements InlinedCodePlugin {
    private String fileName;
    private String text;

    @Override
    public String id() {
        return "file";
    }

    @Override
    public InlinedCodePlugin create() {
        return new FileInlinedCodePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams) {
        this.fileName = pluginParams.getFreeParam();
        this.text = FilePlugin.extractText(componentsRegistry.resourceResolver().textContent(this.fileName), pluginParams.getOpts());
        return PluginResult.docElement("InlinedCode", Collections.singletonMap("code", this.text));
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(AuxiliaryFile.builtTime(componentsRegistry.resourceResolver().fullPath(this.fileName)));
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.STANDARD.text(this.text);
    }
}

