/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.extensions.json;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import znaishaded.com.jayway.jsonpath.JsonPath;
import znaishaded.com.jayway.jsonpath.Predicate;
import znaishaded.org.testingisdocumenting.znai.core.AuxiliaryFile;
import znaishaded.org.testingisdocumenting.znai.core.ComponentsRegistry;
import znaishaded.org.testingisdocumenting.znai.core.ResourcesResolver;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginParams;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginParamsOpts;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginResult;
import znaishaded.org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import znaishaded.org.testingisdocumenting.znai.parser.ParserHandler;
import znaishaded.org.testingisdocumenting.znai.utils.JsonUtils;

public class JsonIncludePlugin
implements IncludePlugin {
    private String fileName;
    private ResourcesResolver resourcesResolver;
    private Path pathsFilePath;

    @Override
    public String id() {
        return "json";
    }

    @Override
    public IncludePlugin create() {
        return new JsonIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.resourcesResolver = componentsRegistry.resourceResolver();
        this.fileName = pluginParams.getFreeParam();
        String json = this.resourcesResolver.textContent(this.fileName);
        String jsonPath = pluginParams.getOpts().get("include", "$");
        Object content = JsonPath.read(json, jsonPath, new Predicate[0]);
        Map<String, Object> props = pluginParams.getOpts().toMap();
        props.put("data", content);
        props.put("paths", this.extractPaths(pluginParams.getOpts()));
        return PluginResult.docElement("Json", props);
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        Stream pathsFile = this.pathsFilePath == null ? Stream.empty() : Stream.of(AuxiliaryFile.builtTime(this.pathsFilePath));
        return Stream.concat(pathsFile, Stream.of(AuxiliaryFile.builtTime(componentsRegistry.resourceResolver().fullPath(this.fileName))));
    }

    private List<String> extractPaths(PluginParamsOpts opts) {
        if (opts.has("pathsFile")) {
            String filePath = (String)opts.get("pathsFile");
            this.pathsFilePath = this.resourcesResolver.fullPath(filePath);
            return JsonUtils.deserializeAsList(this.resourcesResolver.textContent(filePath));
        }
        return opts.getList("paths");
    }
}

