/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.extensions.reactjs;

import java.nio.file.Path;
import znaishaded.org.testingisdocumenting.znai.core.ComponentsRegistry;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginParams;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginResult;
import znaishaded.org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import znaishaded.org.testingisdocumenting.znai.parser.ParserHandler;
import znaishaded.org.testingisdocumenting.znai.utils.CollectionUtils;

public class ReactJsComponentIncludePlugin
implements IncludePlugin {
    @Override
    public String id() {
        return "reactjs-component";
    }

    @Override
    public IncludePlugin create() {
        return new ReactJsComponentIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        ComponentPath componentPath = ReactJsComponentIncludePlugin.extractComponentPath(pluginParams.getFreeParam());
        return PluginResult.docElement("CustomReactJSComponent", CollectionUtils.createMap("namespace", componentPath.namespace, "name", componentPath.name, "props", pluginParams.getOpts().toMap()));
    }

    private static ComponentPath extractComponentPath(String fullName) {
        String[] parts = fullName.split("\\.");
        if (parts.length != 2) {
            throw new IllegalArgumentException("component path must be specified as <namespace>.<name>, given: " + fullName);
        }
        return new ComponentPath(parts[0], parts[1]);
    }

    private static class ComponentPath {
        private String namespace;
        private String name;

        ComponentPath(String namespace, String name) {
            this.namespace = namespace;
            this.name = name;
        }
    }
}

