/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.extensions.reveal;

import java.nio.file.Path;
import java.util.stream.Stream;
import znaishaded.org.testingisdocumenting.znai.core.AuxiliaryFile;
import znaishaded.org.testingisdocumenting.znai.core.ComponentsRegistry;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginParams;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginResult;
import znaishaded.org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import znaishaded.org.testingisdocumenting.znai.parser.MarkupParser;
import znaishaded.org.testingisdocumenting.znai.parser.MarkupParserResult;
import znaishaded.org.testingisdocumenting.znai.search.SearchScore;
import znaishaded.org.testingisdocumenting.znai.search.SearchText;
import znaishaded.org.testingisdocumenting.znai.utils.CollectionUtils;

public class SpoilerFencePlugin
implements FencePlugin {
    private MarkupParserResult parserResult;

    @Override
    public String id() {
        return "spoiler";
    }

    @Override
    public FencePlugin create() {
        return new SpoilerFencePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams, String content) {
        MarkupParser markupParser = componentsRegistry.defaultParser();
        this.parserResult = markupParser.parse(markupPath, content);
        String title = pluginParams.getOpts().get("title", "Press to reveal");
        return PluginResult.docElement("Spoiler", CollectionUtils.createMap("title", title, "content", this.parserResult.contentToListOfMaps()));
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return this.parserResult.getAuxiliaryFiles().stream();
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.LOW.text(this.parserResult.getAllText());
    }
}

