/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.extensions.xml;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;
import znaishaded.org.testingisdocumenting.znai.utils.XmlUtils;

public class XmlToMapRepresentationConverter
extends DefaultHandler {
    private final List<Map<String, Object>> result;
    private final Deque<List<Map<String, Object>>> currentStack = new ArrayDeque<List<Map<String, Object>>>();
    private StringBuilder accumulatedText;

    public static Map<String, ?> convert(String xmlContent) {
        return new XmlToMapRepresentationConverter().convertXml(xmlContent);
    }

    private XmlToMapRepresentationConverter() {
        this.result = new ArrayList<Map<String, Object>>();
        this.currentStack.add(this.result);
        this.accumulatedText = new StringBuilder();
    }

    private Map<String, ?> convertXml(String xmlContent) {
        XmlUtils.parseXml(xmlContent, this);
        return this.result.get(0);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        LinkedHashMap<String, Object> asMap = new LinkedHashMap<String, Object>();
        ArrayList children = new ArrayList();
        asMap.put("tagName", qName);
        asMap.put("attributes", this.parseAttributes(attributes));
        asMap.put("children", children);
        this.currentStack.peekLast().add(asMap);
        this.currentStack.add(children);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.accumulatedText.append(new String(ch, start, length));
    }

    private Map<String, Object> createTextNode(String text) {
        LinkedHashMap<String, Object> textNode = new LinkedHashMap<String, Object>();
        textNode.put("tagName", "");
        textNode.put("text", text);
        return textNode;
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (!this.accumulatedText.toString().trim().isEmpty()) {
            this.currentStack.peekLast().add(this.createTextNode(this.accumulatedText.toString().trim()));
        }
        this.currentStack.removeLast();
        this.accumulatedText = new StringBuilder();
    }

    private List<Map<String, Object>> parseAttributes(Attributes attributes) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        int len = attributes.getLength();
        for (int i = 0; i < len; ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            LinkedHashMap<String, String> attr = new LinkedHashMap<String, String>();
            attr.put("name", name);
            attr.put("value", "\"" + value + "\"");
            result.add(attr);
        }
        return result;
    }
}

