/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.gen;

import java.nio.file.Path;
import java.nio.file.Paths;
import znaishaded.org.apache.commons.cli.CommandLine;
import znaishaded.org.apache.commons.cli.DefaultParser;
import znaishaded.org.apache.commons.cli.HelpFormatter;
import znaishaded.org.apache.commons.cli.Options;
import znaishaded.org.apache.commons.cli.ParseException;

class CliConfig {
    private static final String SECTION_ID = "sectionId";
    private static final String DEST = "znaiDest";
    private static final String ROOT = "readmeRoot";
    private static final String HELP = "help";
    private final CommandLine commandLine;
    private Path readmeRoot;
    private Path znaiDest;
    private String sectionId;

    CliConfig(String[] args) {
        Options options = this.createOptions();
        this.commandLine = this.createCommandLine(args, options);
        if (this.commandLine.hasOption(HELP) || args.length < 3) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("znai-gen", options);
            System.exit(1);
        }
        this.readmeRoot = this.retrievePath(ROOT);
        this.znaiDest = this.retrievePath(DEST);
        this.sectionId = this.commandLine.getOptionValue(SECTION_ID);
    }

    String getSectionId() {
        return this.sectionId;
    }

    Path getReadmeRoot() {
        return this.readmeRoot;
    }

    Path getZnaiDest() {
        return this.znaiDest;
    }

    private Path retrievePath(String optName) {
        return Paths.get(this.commandLine.getOptionValue(optName), new String[0]);
    }

    private CommandLine createCommandLine(String[] args, Options options) {
        DefaultParser parser = new DefaultParser();
        try {
            return parser.parse(options, args);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private Options createOptions() {
        Options options = new Options();
        options.addOption(null, HELP, false, "print help");
        options.addOption(null, ROOT, true, "location of the readme root dir");
        options.addOption(null, DEST, true, "output location");
        options.addOption(null, SECTION_ID, true, "znai section id where to put content");
        return options;
    }
}

