/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.html;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import znaishaded.org.testingisdocumenting.znai.html.RenderSupplier;
import znaishaded.org.testingisdocumenting.znai.web.WebResource;

public class HtmlPage {
    public static final String FAVICON_PATH = "favicon.png";
    private final String customFavIconPath;
    private String title;
    private List<WebResource> cssResources;
    private List<WebResource> javaScriptResources;
    private List<RenderSupplier> headSuppliers;
    private List<RenderSupplier> bodySuppliers;
    private List<RenderSupplier> javaScriptSuppliers;

    public HtmlPage() {
        this("");
    }

    public HtmlPage(String customFavIconPath) {
        this.customFavIconPath = customFavIconPath;
        this.title = "";
        this.cssResources = new ArrayList<WebResource>();
        this.javaScriptResources = new ArrayList<WebResource>();
        this.headSuppliers = new ArrayList<RenderSupplier>();
        this.bodySuppliers = new ArrayList<RenderSupplier>();
        this.javaScriptSuppliers = new ArrayList<RenderSupplier>();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void addCss(WebResource webResource) {
        this.cssResources.add(webResource);
    }

    public void addJavaScript(WebResource webResource) {
        this.javaScriptResources.add(webResource);
    }

    public void addJavaScriptInFront(WebResource webResource) {
        this.javaScriptResources.add(0, webResource);
    }

    public void addToHead(RenderSupplier supplier) {
        this.headSuppliers.add(supplier);
    }

    public void addToBody(RenderSupplier supplier) {
        this.bodySuppliers.add(supplier);
    }

    public void addToJavaScript(RenderSupplier supplier) {
        this.javaScriptSuppliers.add(supplier);
    }

    public String render(String documentationId) {
        return "<!DOCTYPE html>\n<html>\n<head>\n<meta charset=\"utf-8\" /> \n<title>" + this.title + "</title>" + this.headSuppliers.stream().map(RenderSupplier::render).collect(Collectors.joining("\n")) + this.cssResources.stream().map(r -> r.generateCssLink(documentationId)).collect(Collectors.joining("\n")) + "\n</head>\n<link rel=\"shortcut icon\" href=" + this.favIconPath(documentationId) + "type=\"image/ico\"/>\n<body>\n" + this.bodySuppliers.stream().map(RenderSupplier::render).collect(Collectors.joining("\n")) + "\n" + this.javaScriptResources.stream().map(r -> r.generateJavaScriptLink(documentationId)).collect(Collectors.joining("\n")) + "\n<script>\n" + this.javaScriptSuppliers.stream().map(RenderSupplier::render).collect(Collectors.joining("\n")) + "\n</script>\n\n</body>\n</html>\n";
    }

    private String favIconPath(String documentationId) {
        if (!this.customFavIconPath.isEmpty()) {
            return this.makeIconPath(this.customFavIconPath);
        }
        return documentationId.isEmpty() ? this.makeIconPath("/favicon.png") : this.makeIconPath("/" + documentationId + "/" + FAVICON_PATH);
    }

    private String makeIconPath(String path2) {
        return "\"" + path2 + "\"";
    }
}

