/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.html;

import java.util.stream.Collectors;
import znaishaded.org.apache.commons.lang3.StringEscapeUtils;
import znaishaded.org.testingisdocumenting.znai.parser.PageSectionIdTitle;
import znaishaded.org.testingisdocumenting.znai.search.PageSearchEntries;
import znaishaded.org.testingisdocumenting.znai.search.PageSearchEntry;
import znaishaded.org.testingisdocumenting.znai.structure.TableOfContents;
import znaishaded.org.testingisdocumenting.znai.structure.TocItem;
import znaishaded.org.testingisdocumenting.znai.utils.ResourceUtils;

public class ServerSideSimplifiedRenderer {
    static final String LOADING_INDICATOR = ResourceUtils.textContent("template/initial-page-loading.html");

    public static String renderToc(TableOfContents toc) {
        return ServerSideSimplifiedRenderer.section(toc.getTocItems().stream().map(ServerSideSimplifiedRenderer::renderTocLink).collect(Collectors.joining("\n")));
    }

    public static String renderPageTextContent(PageSearchEntries pageSearchEntries) {
        return LOADING_INDICATOR + ServerSideSimplifiedRenderer.section(pageSearchEntries.getEntries().stream().map(ServerSideSimplifiedRenderer::renderPageEntry).collect(Collectors.joining("\n")));
    }

    private static String renderTocLink(TocItem tocItem) {
        String rootLink = ServerSideSimplifiedRenderer.aHref(tocItem.getDirName() + "/" + tocItem.getFileNameWithoutExtension() + "/", tocItem.getPageTitle());
        String subLinks = tocItem.getPageSectionIdTitles().stream().map(section -> ServerSideSimplifiedRenderer.renderTocSubLink(tocItem, section)).collect(Collectors.joining(""));
        return ServerSideSimplifiedRenderer.article(rootLink + subLinks);
    }

    private static String renderTocSubLink(TocItem tocItem, PageSectionIdTitle pageSectionIdTitle) {
        return ServerSideSimplifiedRenderer.aHref(tocItem.getDirName() + "/" + tocItem.getFileNameWithoutExtension() + "/#" + pageSectionIdTitle.getId(), tocItem.getPageTitle() + " " + pageSectionIdTitle.getTitle());
    }

    private static String renderPageEntry(PageSearchEntry entry) {
        String optionalHeader = entry.getPageSectionTitle().isEmpty() ? "" : "<header><h1>" + entry.getPageSectionTitle() + "</h1></header>\n";
        String paragraph = "<p>" + StringEscapeUtils.escapeHtml4(entry.getSearchText().getText()) + "</p>\n";
        return ServerSideSimplifiedRenderer.article(optionalHeader + paragraph);
    }

    private static String section(String htmlBlock) {
        return "<section style=\"max-width: 640px; margin-left: auto; margin-right: auto;\">\n" + htmlBlock + "</section>\n";
    }

    private static String article(String htmlBlock) {
        return "<article>\n" + htmlBlock + "</article>\n";
    }

    private static String aHref(String url, String title) {
        return "<a href=\"" + url + "\">" + title + "</a>\n";
    }
}

