/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.html.reactjs;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import znaishaded.org.testingisdocumenting.znai.html.Deployer;
import znaishaded.org.testingisdocumenting.znai.web.WebResource;

public class ReactJsBundle {
    private final WebResource mainJs = WebResource.fromResource("static/main.js");
    private final WebResource mainCss = WebResource.fromResource("static/main.css");
    private final WebResource react;
    private final WebResource reactDom;
    private final WebResource bootstrapCss = WebResource.fromResource("static/css/bootstrap.min.css");
    private final WebResource katexCss = WebResource.fromResource("static/css/katex.min.css");
    private final List<WebResource> fonts;

    public ReactJsBundle() {
        this.react = WebResource.fromResource("static/react.min.js");
        this.reactDom = WebResource.fromResource("static/react-dom.min.js");
        Stream<WebResource> glyphIcons = Stream.of("eot", "svg", "ttf", "woff", "woff2").map(ext -> "static/fonts/glyphicons-halflings-regular." + ext).map(WebResource::fromResource);
        Stream katexFonts = Stream.of("ttf", "woff", "woff2").flatMap(ext -> Stream.of("KaTeX_Main-Bold." + ext, "KaTeX_Main-BoldItalic." + ext, "KaTeX_Main-Italic." + ext, "KaTeX_Main-Regular." + ext, "KaTeX_Math-BoldItalic." + ext, "KaTeX_Math-Italic." + ext).map(name -> WebResource.fromResource("static/fonts/" + name)));
        this.fonts = Stream.concat(glyphIcons, katexFonts).collect(Collectors.toList());
    }

    public Stream<WebResource> clientJavaScripts() {
        return Stream.of(this.react, this.reactDom, this.mainJs);
    }

    public Stream<WebResource> clientCssResources() {
        return Stream.of(this.bootstrapCss, this.katexCss, this.mainCss);
    }

    public void deploy(Deployer deployer) {
        Stream.concat(Stream.concat(this.clientJavaScripts(), this.clientCssResources()), this.fonts.stream()).forEach(deployer::deploy);
    }
}

