/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.java.extensions;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginResult;
import znaishaded.org.testingisdocumenting.znai.extensions.api.ApiParameters;
import znaishaded.org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import znaishaded.org.testingisdocumenting.znai.java.extensions.JavaIncludePluginBase;
import znaishaded.org.testingisdocumenting.znai.java.extensions.JavaIncludeResult;
import znaishaded.org.testingisdocumenting.znai.java.parser.EnumEntry;
import znaishaded.org.testingisdocumenting.znai.java.parser.JavaCode;
import znaishaded.org.testingisdocumenting.znai.java.parser.html.HtmlToDocElementConverter;
import znaishaded.org.testingisdocumenting.znai.parser.docelement.DocElement;

public class JavaEnumEntriesIncludePlugin
extends JavaIncludePluginBase {
    @Override
    public String id() {
        return "java-enum-entries";
    }

    @Override
    public IncludePlugin create() {
        return new JavaEnumEntriesIncludePlugin();
    }

    @Override
    public JavaIncludeResult process(JavaCode javaCode) {
        ApiParameters apiParameters = new ApiParameters();
        javaCode.getEnumEntries().stream().filter(this::includeEnum).forEach(enumEntry -> apiParameters.add(enumEntry.getName(), "", this.javaDocTextToDocElements(enumEntry.getJavaDocText())));
        Map<String, Object> props = apiParameters.toMap();
        this.features.updateProps(props);
        props.putAll(this.pluginParams.getOpts().toMap());
        List<DocElement> docElements = PluginResult.docElement("ApiParameters", props).getDocElements();
        return new JavaIncludeResult(docElements, this.extractText(javaCode.getEnumEntries()));
    }

    private boolean includeEnum(EnumEntry enumEntry) {
        boolean excludeDeprecated = this.pluginParams.getOpts().get("excludeDeprecated", false);
        return !excludeDeprecated || !enumEntry.isDeprecated();
    }

    private String extractText(List<EnumEntry> enums) {
        return enums.stream().map(e -> e.getName() + " " + e.getJavaDocText()).collect(Collectors.joining(" "));
    }

    private List<Map<String, Object>> nameToDocElements(EnumEntry e) {
        return Collections.singletonList(new DocElement("InlinedCode", "code", e.getName()).toMap());
    }

    private List<Map<String, Object>> descriptionToDocElements(EnumEntry e) {
        return HtmlToDocElementConverter.convert(this.componentsRegistry, this.markupPath, e.getJavaDocText(), this.codeReferencesFeature.getReferences()).stream().map(DocElement::toMap).collect(Collectors.toList());
    }
}

