/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.java.parser;

import java.util.List;
import java.util.stream.Collectors;
import znaishaded.org.testingisdocumenting.znai.java.parser.JavaMethodParam;
import znaishaded.org.testingisdocumenting.znai.java.parser.JavaMethodReturn;

public class JavaMethod {
    private String name;
    private String nameWithTypes;
    private String fullBody;
    private String bodyOnly;
    private String signatureOnly;
    private String javaDocText;
    private List<JavaMethodParam> params;
    private JavaMethodReturn javaMethodReturn;

    public JavaMethod(String name, String fullBody, String bodyOnly, String signatureOnly, List<JavaMethodParam> params, JavaMethodReturn javaMethodReturn, String javaDocText) {
        this.name = name;
        this.nameWithTypes = name + "(" + params.stream().map(JavaMethodParam::getType).collect(Collectors.joining(",")) + ")";
        this.fullBody = fullBody;
        this.bodyOnly = bodyOnly;
        this.signatureOnly = signatureOnly;
        this.javaDocText = javaDocText;
        this.params = params;
        this.javaMethodReturn = javaMethodReturn != null && javaMethodReturn.getType().equals("void") ? null : javaMethodReturn;
    }

    public String getName() {
        return this.name;
    }

    public String getNameWithTypes() {
        return this.nameWithTypes;
    }

    public String getFullBody() {
        return this.fullBody;
    }

    public String getBodyOnly() {
        return this.bodyOnly;
    }

    public String getJavaDocText() {
        return this.javaDocText;
    }

    public String getSignatureOnly() {
        return this.signatureOnly;
    }

    public List<JavaMethodParam> getParams() {
        return this.params;
    }

    public JavaMethodReturn getJavaMethodReturn() {
        return this.javaMethodReturn;
    }

    public List<String> getParamNames() {
        return this.params.stream().map(JavaMethodParam::getName).collect(Collectors.toList());
    }
}

