/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.jupyter;

import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import znaishaded.org.testingisdocumenting.znai.codesnippets.CodeSnippetsProps;
import znaishaded.org.testingisdocumenting.znai.core.AuxiliaryFile;
import znaishaded.org.testingisdocumenting.znai.core.ComponentsRegistry;
import znaishaded.org.testingisdocumenting.znai.core.ResourcesResolver;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginParams;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginResult;
import znaishaded.org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import znaishaded.org.testingisdocumenting.znai.jupyter.JupyterCell;
import znaishaded.org.testingisdocumenting.znai.jupyter.JupyterNotebook;
import znaishaded.org.testingisdocumenting.znai.jupyter.JupyterOutput;
import znaishaded.org.testingisdocumenting.znai.jupyter.JupyterParserVer4;
import znaishaded.org.testingisdocumenting.znai.parser.ParserHandler;
import znaishaded.org.testingisdocumenting.znai.parser.commonmark.MarkdownParser;
import znaishaded.org.testingisdocumenting.znai.utils.JsonUtils;

public class JupyterIncludePlugin
implements IncludePlugin {
    private MarkdownParser markdownParser;
    private Path path;
    private String lang;
    private boolean isStoryFirst;
    private ParserHandler markdownParserHandler;

    @Override
    public String id() {
        return "jupyter";
    }

    @Override
    public IncludePlugin create() {
        return new JupyterIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.markdownParser = componentsRegistry.markdownParser();
        this.markdownParserHandler = parserHandler;
        this.isStoryFirst = pluginParams.getOpts().get("storyFirst", false);
        ResourcesResolver resourcesResolver = componentsRegistry.resourceResolver();
        this.path = resourcesResolver.fullPath(pluginParams.getFreeParam());
        JupyterNotebook notebook = new JupyterParserVer4().parse(JsonUtils.deserializeAsMap(resourcesResolver.textContent(this.path)));
        this.lang = notebook.getLang();
        notebook.getCells().forEach(this::processCell);
        return PluginResult.docElements(Stream.empty());
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(AuxiliaryFile.builtTime(this.path));
    }

    private void processCell(JupyterCell cell2) {
        this.processMarkdownCell(cell2);
        if (this.isStoryFirst) {
            this.processOutputFromCell(cell2);
            this.processInputFromCell(cell2);
        } else {
            this.processInputFromCell(cell2);
            this.processOutputFromCell(cell2);
        }
    }

    private void processMarkdownCell(JupyterCell cell2) {
        if (!cell2.getType().equals("markdown")) {
            return;
        }
        this.markdownParser.parse(this.path, cell2.getInput(), this.markdownParserHandler);
    }

    private void processInputFromCell(JupyterCell cell2) {
        if (this.isMarkdown(cell2)) {
            return;
        }
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("cellType", cell2.getType());
        props.putAll(this.convertInputData(cell2));
        if (this.isStoryFirst) {
            props.putAll(this.createMetaRight());
        }
        this.addCell(props);
    }

    private void processOutputFromCell(JupyterCell cell2) {
        if (cell2.getOutputs().isEmpty()) {
            this.processEmptyOutput();
        } else {
            cell2.getOutputs().forEach(this::processCellOutput);
        }
    }

    private void processCellOutput(JupyterOutput output) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("cellType", "output");
        props.putAll(this.convertOutputData(output));
        if (!this.isStoryFirst) {
            props.putAll(this.createMetaRight());
        }
        this.addCell(props);
    }

    private void processEmptyOutput() {
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put("cellType", "empty-output");
        props.putAll(this.createMetaRight());
        this.addCell(props);
    }

    private void addCell(Map<String, ?> props) {
        this.markdownParserHandler.onCustomNode("JupyterCell", props);
    }

    private boolean isMarkdown(JupyterCell cell2) {
        return cell2.getType().equals("markdown");
    }

    private Map<String, ?> createMetaRight() {
        LinkedHashMap<String, Boolean> meta = new LinkedHashMap<String, Boolean>();
        meta.put("rightSide", true);
        return Collections.singletonMap("meta", meta);
    }

    private Map<String, Object> convertInputData(JupyterCell cell2) {
        switch (cell2.getType()) {
            case "code": {
                return CodeSnippetsProps.create(this.lang, cell2.getInput());
            }
        }
        return Collections.singletonMap("text", cell2.getInput());
    }

    private Map<String, Object> convertOutputData(JupyterOutput output) {
        return Collections.singletonMap(output.getFormat(), output.getContent());
    }
}

