/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.openapi;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import znaishaded.org.testingisdocumenting.znai.openapi.OpenApiParameter;

public class OpenApiOperation {
    private String id;
    private String method;
    private String summary;
    private String path;
    private List<String> consumes;
    private List<String> produces;
    private List<String> tags = new ArrayList<String>();
    private List<Map<String, Object>> description = new ArrayList<Map<String, Object>>();
    private List<OpenApiParameter> parameters = new ArrayList<OpenApiParameter>();
    private List<Map<String, ?>> responses = new ArrayList();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id must be not null");
        }
        this.id = id;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path2) {
        this.path = path2;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getSummary() {
        return this.summary;
    }

    public List<OpenApiParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<OpenApiParameter> parameters) {
        this.parameters = parameters;
    }

    public List<Map<String, ?>> getResponses() {
        return this.responses;
    }

    public void setResponses(List<Map<String, ?>> responses) {
        this.responses = responses;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean matches(String method, String path2) {
        return this.method.equals(method) && this.path.equals(path2);
    }

    public boolean hasTags(List<String> tagsToCheck) {
        return this.tags != null && this.tags.containsAll(tagsToCheck);
    }

    public List<Map<String, Object>> getDescription() {
        return this.description;
    }

    public void setDescription(List<Map<String, Object>> description) {
        this.description = description;
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("id", this.id);
        result.put("method", this.method);
        result.put("path", this.path);
        result.put("consumes", this.consumes);
        result.put("produces", this.produces);
        result.put("summary", this.summary);
        result.put("tags", this.tags);
        result.put("parameters", this.parameters.stream().map(OpenApiParameter::toMap).collect(Collectors.toList()));
        result.put("responses", this.responses);
        result.put("description", this.description);
        return result;
    }

    public String toString() {
        return "OpenApiOperation{id='" + this.id + '\'' + ", method='" + this.method + '\'' + ", summary='" + this.summary + '\'' + ", path='" + this.path + '\'' + ", tags=" + this.tags + ", description=" + this.description + ", parameters=" + this.parameters + ", responses=" + this.responses + '}';
    }
}

